/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONFunction;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.web.event.Listener;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;

public class MenuButton
extends Button {
    protected Button[] menuItems;

    public MenuButton(String string, String string2) {
        super(string, string2);
    }

    public String getXType() {
        return "menubutton";
    }

    public Button[] getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(Button[] buttonArray) {
        this.menuItems = buttonArray;
    }

    public Button[] createMenuItems() {
        return this.getMenuItems();
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        this.setDisabled(true);
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        Object[] objectArray = this.createMenuItems();
        if (!ArrayUtils.isEmpty(objectArray)) {
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("menu", jSONArray);
            block0: for (int i = 0; i < objectArray.length; ++i) {
                JSONObject jSONObject2 = ((Button)objectArray[i]).createChildConfig(repository);
                jSONArray.put(jSONObject2);
                Listener[] listenerArray = ((Widget)objectArray[i]).createListeners(repository);
                for (int j = 0; j < listenerArray.length; ++j) {
                    if (!ComparatorUtils.equals("click", listenerArray[j].getName())) continue;
                    jSONObject2.put("handler", new JSONFunction(new String[]{"e", "item"}, listenerArray[j].getAction().createJS(repository)));
                    continue block0;
                }
            }
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Widget")) {
            ArrayUtils.add(this.menuItems, ReportXMLUtils.readButton(xMLableReader));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        for (int i = 0; this.menuItems != null && i < this.menuItems.length; ++i) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.menuItems[i], "Widget");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MenuButton)) {
            return false;
        }
        return super.equals(object) && ComparatorUtils.equals(this.menuItems, ((MenuButton)object).menuItems);
    }

    public Object clone() throws CloneNotSupportedException {
        MenuButton menuButton = (MenuButton)super.clone();
        if (this.menuItems != null) {
            menuButton.menuItems = new Button[this.menuItems.length];
            for (int i = 0; i < this.menuItems.length; ++i) {
                menuButton.menuItems[i] = (MenuButton)this.menuItems[i].clone();
            }
        }
        return menuButton;
    }
}

