/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.FieldEditor;
import com.fr.report.web.ui.FileEditor;
import com.fr.web.Repository;

public class MultiFileEditor
extends FieldEditor {
    public static final String EVENT_UPLOAD_CALLBACK = "callback";
    private boolean autoUpload = true;
    private int maxLength = -1;
    private String url;
    private String accept;

    public boolean isAutoUpload() {
        return this.autoUpload;
    }

    public void setAutoUpload(boolean bl) {
        this.autoUpload = bl;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAccept(String string) {
        this.accept = string;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getXType() {
        return "multifile";
    }

    public String[] supportedEvents() {
        Object[] objectArray = new String[]{EVENT_UPLOAD_CALLBACK};
        return (String[])ArrayUtils.addAll(super.supportedEvents(), objectArray);
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (!this.autoUpload) {
            jSONObject.put("autoUpload", false);
        }
        if (!StringUtils.isBlank(this.getUrl())) {
            jSONObject.put("url", this.getUrl());
        }
        if (!StringUtils.isEmpty(this.getAccept())) {
            jSONObject.put("accept", this.getAccept());
        }
        if (this.maxLength != -1) {
            jSONObject.put("maxlength", this.maxLength);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("FileAttr")) {
            String string = null;
            string = xMLableReader.getAttr("url");
            if (string != null) {
                this.setUrl(string);
            }
            if ((string = xMLableReader.getAttr("autoUpload")) != null) {
                this.setAutoUpload(false);
            }
            if ((string = xMLableReader.getAttr("maxlength")) != null) {
                this.setMaxLength(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("accept")) != null) {
                this.setAccept(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("FileAttr");
        if (this.getUrl() != null) {
            xMLPrintWriter.attr("url", this.getUrl());
        }
        if (!this.autoUpload) {
            xMLPrintWriter.attr("autoUpload", this.autoUpload);
        }
        if (this.maxLength != -1) {
            xMLPrintWriter.attr("maxlength", this.maxLength);
        }
        if (!StringUtils.isEmpty(this.getAccept())) {
            xMLPrintWriter.attr("accept", this.getAccept());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileEditor)) {
            return false;
        }
        return ComparatorUtils.equals(((MultiFileEditor)object).getUrl(), this.getUrl());
    }
}

