/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.FieldEditor;
import com.fr.util.Utils;
import com.fr.web.Repository;

public class NumberEditor
extends FieldEditor {
    private int maxIntegerLength = 32;
    private int maxDecimalLength = 16;
    private boolean allowDecimals = true;
    private boolean allowNegative = true;
    private double minValue = -1.7976931348623157E308;
    private double maxValue = Double.MAX_VALUE;

    public String getXType() {
        return "number";
    }

    public int getMaxIntegerLength() {
        return this.maxIntegerLength;
    }

    public void setMaxIntegerLength(int n) {
        this.maxIntegerLength = n;
    }

    public int getMaxDecimalLength() {
        return this.maxDecimalLength;
    }

    public void setMaxDecimalLength(int n) {
        this.maxDecimalLength = n;
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setAllowDecimals(boolean bl) {
        this.allowDecimals = bl;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean bl) {
        this.allowNegative = bl;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    protected Object value2Config(Object object) {
        return Utils.objectToNumber(object, true);
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("maxIntLength", this.getMaxIntegerLength()).put("maxDecLength", this.getMaxDecimalLength());
        if (!this.isAllowDecimals()) {
            jSONObject.put("allowDecimals", this.isAllowDecimals());
        }
        if (!this.isAllowNegative()) {
            jSONObject.put("allowNegative", this.isAllowNegative());
        }
        if (this.getMinValue() != -1.7976931348623157E308) {
            jSONObject.put("minValue", this.getMinValue());
        }
        if (this.getMaxValue() != Double.MAX_VALUE) {
            jSONObject.put("maxValue", this.getMaxValue());
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (xMLableReader.getTagName().equals("NumberAttr") || "Attribute".equals(xMLableReader.getTagName()))) {
            String string = null;
            string = xMLableReader.getAttr("maxIntegerLength");
            if (string != null) {
                this.setMaxIntegerLength(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("maxDecimalLength")) != null) {
                this.setMaxDecimalLength(Integer.parseInt(string));
            }
            if ((string = xMLableReader.getAttr("allowDecimals")) != null) {
                this.setAllowDecimals(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("allowNegative")) != null) {
                this.setAllowNegative(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("minValue")) != null) {
                this.setMinValue(Double.parseDouble(string));
            }
            if ((string = xMLableReader.getAttr("maxValue")) != null) {
                this.setMaxValue(Double.parseDouble(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("NumberAttr");
        if (this.getMaxIntegerLength() != 32) {
            xMLPrintWriter.attr("maxIntegerLength", this.getMaxIntegerLength());
        }
        if (this.getMaxDecimalLength() != 16) {
            xMLPrintWriter.attr("maxDecimalLength", this.getMaxDecimalLength());
        }
        if (!this.isAllowDecimals()) {
            xMLPrintWriter.attr("allowDecimals", this.isAllowDecimals());
        }
        if (!this.isAllowNegative()) {
            xMLPrintWriter.attr("allowNegative", this.isAllowNegative());
        }
        if (this.getMinValue() != -1.7976931348623157E308) {
            xMLPrintWriter.attr("minValue", this.getMinValue());
        }
        if (this.getMaxValue() != Double.MAX_VALUE) {
            xMLPrintWriter.attr("maxValue", this.getMaxValue());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof NumberEditor && super.equals(object) && this.maxIntegerLength == ((NumberEditor)object).maxIntegerLength && this.maxDecimalLength == ((NumberEditor)object).maxDecimalLength && this.allowDecimals == ((NumberEditor)object).allowDecimals && this.allowNegative == ((NumberEditor)object).allowNegative && this.minValue == ((NumberEditor)object).minValue && this.maxValue == ((NumberEditor)object).maxValue;
    }
}

