/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.web.ui.WriteUnableRepeatEditor;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.WidgetService;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class RadioGroup
extends WriteUnableRepeatEditor {
    private Dictionary mvList;

    public String getXType() {
        return "radiogroup";
    }

    public boolean isEditor() {
        return false;
    }

    public void setDictionary(Dictionary dictionary) {
        this.mvList = dictionary;
    }

    public Dictionary getDictionary() {
        return this.mvList;
    }

    public String[] dependence() {
        return this.mvList == null ? new String[]{} : this.mvList.getDependence();
    }

    public String[] supportedEvents() {
        return (String[])ArrayUtils.addAll(super.supportedEvents(), new String[]{"statechange"});
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.mvList == null) {
            return jSONArray;
        }
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        this.mvList.reset();
        Iterator iterator = this.mvList.entrys(calculator);
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            String string = WidgetService.toJSONString(mV.getModel(), httpServletRequest);
            String string2 = WidgetService.toJSONString(mV.getView(), httpServletRequest);
            if (!StringUtils.isNotEmpty(string2)) continue;
            if (this.isRemoveRepeat()) {
                if (arrayList.contains(mV)) continue;
                jSONArray.put(new JSONObject().put("value", string).put("text", string2));
                arrayList.add(mV);
                continue;
            }
            jSONArray.put(new JSONObject().put("value", string).put("text", string2));
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Dictionary")) {
            this.mvList = DataXMLUtils.readXMLDictionary(xMLableReader);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.mvList != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.mvList, "Dictionary");
        }
    }

    public boolean equals(Object object) {
        return object instanceof RadioGroup && super.equals(object) && ComparatorUtils.equals(this.mvList, ((RadioGroup)object).mvList);
    }

    public Object clone() throws CloneNotSupportedException {
        RadioGroup radioGroup = (RadioGroup)super.clone();
        if (this.mvList != null) {
            radioGroup.mvList = (Dictionary)this.mvList.clone();
        }
        return radioGroup;
    }
}

