/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.script.Calculator;
import com.fr.report.web.ui.FieldEditor;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class TableTree
extends FieldEditor {
    public static final String XML_TAG = "TT";
    private String dataUrl;
    private Dictionary dict;

    public String getXType() {
        return "tabletree";
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String string) {
        this.dataUrl = string;
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dict = dictionary;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        if (this.dict == null) {
            return jSONArray;
        }
        this.dict.reset();
        Iterator iterator = this.dict.entrys(calculator);
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            jSONArray.put(new JSONObject().put("state", Utils.objectToString(mV.getModel())).put("name", Utils.objectToString(mV.getView())));
        }
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        Map map = repository.checkoutTplContext();
        try {
            jSONObject.put("url", TemplateUtils.render(this.dataUrl, map));
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.dataUrl = xMLableReader.getAttr("url");
            } else if (string.equals("Dictionary")) {
                this.dict = DataXMLUtils.readXMLDictionary(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!StringUtils.isEmpty(this.dataUrl)) {
            xMLPrintWriter.startTAG(XML_TAG).attr("url", this.dataUrl).end();
        }
        if (this.dict != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.dict, "Dictionary");
        }
    }

    public boolean equals(Object object) {
        return object instanceof TableTree && super.equals(object) && ComparatorUtils.equals(this.dataUrl, ((TableTree)object).dataUrl);
    }
}

