/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.web.ui.FieldEditor;
import com.fr.report.web.ui.reg.CustomReg;
import com.fr.report.web.ui.reg.RegExp;
import com.fr.web.Repository;

public class TextEditor
extends FieldEditor {
    private RegExp regex;
    private String waterMark;

    public String getXType() {
        return "text";
    }

    public RegExp getRegex() {
        return this.regex;
    }

    public void setRegex(RegExp regExp) {
        this.regex = regExp;
    }

    public void setWaterMark(String string) {
        this.waterMark = string;
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("render", true);
        if (this.regex != null) {
            jSONObject.put("regex", this.getRegex().toRegText());
        }
        if (this.waterMark != null) {
            jSONObject.put("watermark", this.waterMark);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("TextAttr") || "Attributes".equals(string)) {
                String string2 = xMLableReader.getAttr("allowBlank");
                if (string2 != null) {
                    this.setAllowBlank(Boolean.valueOf(string2));
                }
            } else if (string.equals("Reg")) {
                this.regex = DataXMLUtils.readXMLReg(xMLableReader);
            } else if (string.equals("Regexp")) {
                this.setRegex(new CustomReg(xMLableReader.getElementValue()));
            } else if ("watermark".equals(string)) {
                this.setWaterMark(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("TextAttr");
        if (!this.isAllowBlank()) {
            xMLPrintWriter.attr("allowBlank", this.isAllowBlank());
        }
        xMLPrintWriter.end();
        if (this.regex != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.regex, "Reg");
        }
        if (StringUtils.isNotBlank(this.waterMark)) {
            xMLPrintWriter.startTAG("watermark").textNode(this.waterMark).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof TextEditor && super.equals(object) && ComparatorUtils.equals(this.regex, ((TextEditor)object).regex);
    }
}

