/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.background.Background;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ToolBar
extends Widget {
    protected List widgets = new ArrayList();
    private boolean isDefault = true;
    private Background background = null;

    public ToolBar() {
    }

    public ToolBar(Widget[] widgetArray) {
        if (widgetArray != null) {
            this.widgets.addAll(Arrays.asList(widgetArray));
        }
    }

    public String getXType() {
        return "toolbar";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[0];
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getWidgetSize() {
        return this.widgets == null ? 0 : this.widgets.size();
    }

    public Widget getWidget(int n) {
        return (Widget)this.widgets.get(n);
    }

    public void addWidget(Widget widget) {
        if (this.widgets == null) {
            this.widgets = new ArrayList();
        }
        this.widgets.add(widget);
    }

    public Widget removeWidget(int n) {
        if (this.widgets == null || this.widgets.size() <= n) {
            return null;
        }
        return (Widget)this.widgets.remove(n);
    }

    public void clearWidgets() {
        if (this.widgets != null) {
            this.widgets.clear();
        }
    }

    public JSONObject createJSONConfig(Repository repository) throws JSONException {
        return this.createJSONConfig(null, repository);
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("disabled", this.isDisabled() ? "true" : "false");
        jSONObject.put("items", this.createJSONComponents(repository));
        if (!this.isDefault) {
            if (this.background != null) {
                jSONObject.put("toolbarbg", HTMLWriterUtils.jsonBackground(this.background, repository));
            } else {
                jSONObject.put("toolbarbg", "none");
            }
        }
        return jSONObject;
    }

    private JSONArray createJSONComponents(Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n = this.widgets.size();
        for (int i = 0; i < n; ++i) {
            jSONArray.put(((Widget)this.widgets.get(i)).createJSONConfig(null, repository));
        }
        return jSONArray;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ToolBar");
        int n = this.getWidgetSize();
        for (int i = 0; i < n; ++i) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.getWidget(i), "Widget");
        }
        if (!this.isDefault()) {
            xMLPrintWriter.startTAG("IsDefault").textNode(String.valueOf(this.isDefault)).end();
            if (this.background != null) {
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearWidgets();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Widget")) {
                Widget widget = ReportXMLUtils.readWidget(xMLableReader);
                this.addWidget(widget);
            } else if ("Background".equals(string)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if ("IsDefault".equals(string)) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setDefault(Boolean.valueOf(string2));
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ToolBar)) {
            return false;
        }
        ToolBar toolBar = (ToolBar)object;
        return super.equals(object) && ComparatorUtils.equals(this.widgets, toolBar.widgets) && this.isDefault == toolBar.isDefault && ComparatorUtils.equals(this.background, toolBar.background);
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBar toolBar = (ToolBar)super.clone();
        if (this.widgets != null) {
            toolBar.widgets = new ArrayList(this.widgets.size());
            int n = this.widgets.size();
            for (int i = 0; i < n; ++i) {
                toolBar.widgets.add(((Widget)this.widgets.get(i)).clone());
            }
        }
        if (this.background != null) {
            toolBar.background = (Background)this.background.clone();
        }
        return toolBar;
    }
}

