/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.condition.Condition;
import com.fr.data.core.DataXMLUtils;
import com.fr.report.js.JavaScriptImpl;
import com.fr.report.web.event.ActionUtils;
import com.fr.report.web.event.Listener;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.WebContentUtils;
import com.fr.web.Repository;

public abstract class ToolBarButton
extends Button {
    protected Condition condition;

    public ToolBarButton(String string) {
        super(string);
        this.setDisabled(true);
    }

    public ToolBarButton(String string, String string2) {
        super(string, string2);
        this.setDisabled(true);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Listener[] createListeners(Repository repository) {
        return new Listener[]{new Listener("click", new JavaScriptImpl(this.clickAction(repository))), new Listener(WebContentUtils.getContentPanel(repository), "startload", new JavaScriptImpl(ActionUtils.getDisableAction())), new Listener(WebContentUtils.getContentPanel(repository), "afterload", new JavaScriptImpl(this.onContentPanelAfterLoad(repository)))};
    }

    protected abstract String clickAction(Repository var1);

    protected String onContentPanelAfterLoad(Repository repository) {
        return ActionUtils.getEnableAction();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
            this.condition = DataXMLUtils.readCondition(xMLableReader);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.condition != null) {
            DataXMLUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ToolBarButton)) {
            return false;
        }
        return super.equals(object);
    }
}

