/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.Dictionary;
import com.fr.data.condition.Condition;
import com.fr.data.impl.JQNode;
import com.fr.data.impl.TreeAttr;
import com.fr.data.impl.TreeNodeAttr;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.script.TreeLayerNameSpace;
import com.fr.report.web.ui.WriteAbleRepeatEditor;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.WidgetService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class TreeEditor
extends WriteAbleRepeatEditor {
    protected TreeAttr treeAttr = new TreeAttr(false);
    protected TreeNodeAttr[] treeNodeAttr;
    private List treeNodeList = new ArrayList();

    public String getXType() {
        return "tree";
    }

    public boolean isEditor() {
        return false;
    }

    public TreeAttr getTreeAttr() {
        return this.treeAttr;
    }

    public void setTreeAttr(TreeAttr treeAttr) {
        this.treeAttr = treeAttr;
    }

    public TreeNodeAttr[] getTreeNodeAttr() {
        return this.treeNodeAttr;
    }

    public void setTreeNodeAttr(TreeNodeAttr[] treeNodeAttrArray) {
        this.treeNodeAttr = treeNodeAttrArray;
    }

    public String[] dependence() {
        if (this.treeNodeAttr == null) {
            return new String[0];
        }
        int n = this.treeNodeAttr.length;
        Object[] objectArray = new String[]{};
        for (int i = 0; i < n; ++i) {
            Dictionary dictionary = this.treeNodeAttr[i].getDictionary();
            objectArray = (String[])ArrayUtils.addAll(dictionary.getDependence(), objectArray);
        }
        return objectArray;
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = super.createJSONData(sessionIDInfor, calculator, httpServletRequest);
        jSONArray = this.getTreeAttr().isAjax() ? this.loadAjaxTreeData(sessionIDInfor, calculator, httpServletRequest) : this.loadDirectTreeData(sessionIDInfor, calculator, httpServletRequest);
        return jSONArray;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        Object[] objectArray;
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("render", true);
        try {
            jSONObject.put("editable", this.isEditable()).put("autoMode", true);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        jSONObject.put("mode", "remote");
        jSONObject.put("async", this.treeAttr.isAjax());
        jSONObject.put("mutiSelection", this.treeAttr.isMultipleSelection());
        if (!this.treeAttr.isCascade()) {
            jSONObject.put("cascadecheck", false);
        }
        if (this.treeAttr.isMultipleSelection() && !this.treeAttr.isReturnArray()) {
            jSONObject.put("returnArray", false);
            if (!StringUtils.isEmpty(this.treeAttr.getDelimiter())) {
                jSONObject.put("delimiter", this.treeAttr.getDelimiter());
            }
            if (!StringUtils.isEmpty(this.treeAttr.getStartSymbol())) {
                jSONObject.put("startSymbol", this.treeAttr.getStartSymbol());
            }
            if (!StringUtils.isEmpty(this.treeAttr.getEndSymbol())) {
                jSONObject.put("endSymbol", this.treeAttr.getEndSymbol());
            }
        }
        if (this.treeAttr.getWidth() > 0) {
            jSONObject.put("popupWidth", this.treeAttr.getWidth());
        }
        if (this.treeAttr.getHeight() > 0) {
            jSONObject.put("popupHeight", this.treeAttr.getHeight());
        }
        if (!ArrayUtils.isEmpty(objectArray = this.dependence())) {
            jSONObject.put("dependence", objectArray);
        }
        return jSONObject;
    }

    private JSONArray loadAjaxTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "value");
        int n = 0;
        if (string != null) {
            n = string.split("-").length;
        }
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        if (string2 != null) {
            HashMap<String, String> hashMap = (HashMap<String, String>)sessionIDInfor.getAttribute("layerMap");
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                sessionIDInfor.setAttribute("layerMap", hashMap);
            }
            hashMap.put(n + "", string2);
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(hashMap);
            calculator.pushNameSpace(treeLayerNameSpace);
        }
        return this.loadAjaxTreeNode(sessionIDInfor, string, n, calculator, httpServletRequest);
    }

    private JSONArray loadAjaxTreeNode(SessionIDInfor sessionIDInfor, String string, int n, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        if (this.getTreeNodeAttr() == null) {
            return null;
        }
        TreeNodeAttr treeNodeAttr = this.getTreeNodeAttr()[n];
        ArrayList arrayList = new ArrayList();
        this.produceAjaxTreeNode(sessionIDInfor, treeNodeAttr, string, n, arrayList, calculator, httpServletRequest);
        return JQNode.toJSONArray(arrayList);
    }

    private void produceAjaxTreeNode(SessionIDInfor sessionIDInfor, TreeNodeAttr treeNodeAttr, String string, int n, List list, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        treeNodeAttr.getDictionary().reset();
        Iterator iterator = treeNodeAttr.getDictionary().entrys(calculator);
        Condition condition = treeNodeAttr.getDictionary().getCondition();
        int n2 = 1;
        ArrayList<Dictionary.MV> arrayList = new ArrayList<Dictionary.MV>();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            Object object = mV.getModel();
            HashMap<String, Object> hashMap = (HashMap<String, Object>)sessionIDInfor.getAttribute("layerMap");
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                sessionIDInfor.setAttribute("layerMap", hashMap);
            }
            hashMap.put(n + 1 + "", object);
            Object object2 = mV.getView();
            if (condition != null && !condition.eval(object, calculator)) continue;
            String string2 = null;
            string2 = n == 0 ? "" + n2 : string + "-" + n2;
            if (this.isRemoveRepeat()) {
                if (!arrayList.contains(mV)) {
                    list.add(new JQNode(string2, WidgetService.toJSONString(object, httpServletRequest), WidgetService.toJSONString(object2, httpServletRequest), this.treeNodeAttr.length != n + 1));
                    arrayList.add(mV);
                }
            } else {
                list.add(new JQNode(string2, WidgetService.toJSONString(object, httpServletRequest), WidgetService.toJSONString(object2, httpServletRequest), this.treeNodeAttr.length != n + 1));
            }
            ++n2;
        }
    }

    private JSONArray loadDirectTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        List list = new ArrayList();
        calculator.pushNameSpace(ParameterMapNameSpace.create(sessionIDInfor.getParameterMap4Execute()));
        calculator.pushNameSpace(new WidgetService.DependenceNameSpace(WebUtils.getHTTPRequestParameter(httpServletRequest, "dependence")));
        ArrayList arrayList = new ArrayList();
        list = this.generatedDirectTreeData(sessionIDInfor, calculator, httpServletRequest, list, arrayList);
        return JQNode.QNode.createTreeNode(list);
    }

    private List generatedDirectTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest, List list, List list2) throws Exception {
        this.traversalTreeData(sessionIDInfor, calculator, httpServletRequest, Utils.objectToString(new Integer(0)), 0, list, list2);
        return list;
    }

    private void traversalTreeData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest, String string, int n, List list, List list2) throws Exception {
        if (n == this.treeNodeAttr.length) {
            return;
        }
        int n2 = 1;
        Dictionary dictionary = this.treeNodeAttr[n].getDictionary();
        dictionary.reset();
        Iterator iterator = dictionary.entrys(calculator);
        Condition condition = dictionary.getCondition();
        while (iterator.hasNext()) {
            Dictionary.MV mV = (Dictionary.MV)iterator.next();
            Object object = mV.getModel();
            HashMap<String, Object> hashMap = (HashMap<String, Object>)sessionIDInfor.getAttribute("layerMap");
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                sessionIDInfor.setAttribute("layerMap", hashMap);
            }
            hashMap.put(Utils.objectToString(new Integer(n + 1)), object);
            TreeLayerNameSpace treeLayerNameSpace = new TreeLayerNameSpace(hashMap);
            calculator.pushNameSpace(treeLayerNameSpace);
            Object object2 = mV.getView();
            if (condition != null && !condition.eval(object, calculator)) continue;
            String string2 = null;
            string2 = n == 0 ? Utils.objectToString(new Integer(n2)) : string + "-" + n2;
            if (this.isRemoveRepeat()) {
                if (!list2.contains(new JQNode.Node(string, mV))) {
                    list.add(new JQNode.QNode(string2, string, WidgetService.toJSONString(object, httpServletRequest), WidgetService.toJSONString(object2, httpServletRequest), this.treeAttr.isMultipleSelection(), 0, true));
                    list2.add(new JQNode.Node(string, mV));
                }
            } else {
                list.add(new JQNode.QNode(string2, string, WidgetService.toJSONString(object, httpServletRequest), WidgetService.toJSONString(object2, httpServletRequest), this.treeAttr.isMultipleSelection(), 0, true));
            }
            this.traversalTreeData(sessionIDInfor, calculator, httpServletRequest, string2, n + 1, list, list2);
            ++n2;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("TreeAttr")) {
                TreeAttr treeAttr = new TreeAttr();
                treeAttr.readXML(xMLableReader);
                this.setTreeAttr(treeAttr);
            } else if (string.equals("TreeNodeAttr")) {
                TreeNodeAttr treeNodeAttr = new TreeNodeAttr();
                xMLableReader.readXMLObject(treeNodeAttr);
                this.treeNodeList.add(treeNodeAttr);
                this.setTreeNodeAttr(this.treeNodeList.toArray(new TreeNodeAttr[this.treeNodeList.size()]));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.treeAttr != null) {
            this.treeAttr.writeXML(xMLPrintWriter);
        }
        if (this.treeNodeAttr != null) {
            int n = this.treeNodeAttr.length;
            for (int i = 0; i < n; ++i) {
                xMLPrintWriter.startTAG("TreeNodeAttr");
                this.treeNodeAttr[i].writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof TreeEditor && super.equals(object) && ComparatorUtils.equals(this.treeAttr, ((TreeEditor)object).treeAttr) && ComparatorUtils.equals(this.treeNodeAttr, ((TreeEditor)object).treeNodeAttr);
    }

    public Object clone() throws CloneNotSupportedException {
        TreeEditor treeEditor = (TreeEditor)super.clone();
        if (this.treeAttr != null) {
            treeEditor.treeAttr = this.treeAttr;
        }
        if (this.treeNodeAttr != null) {
            ArrayList<TreeNodeAttr> arrayList = new ArrayList<TreeNodeAttr>();
            int n = this.treeNodeAttr.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.treeNodeAttr[i]);
            }
            treeEditor.treeNodeAttr = arrayList.toArray(new TreeNodeAttr[arrayList.size()]);
        }
        return treeEditor;
    }
}

