/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.ArrayUtils;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.core.ReportUtils;
import com.fr.report.script.Calculator;
import com.fr.report.web.event.Listener;
import com.fr.report.web.ui.Component;
import com.fr.report.web.ui.container.Container;
import com.fr.web.Repository;
import com.fr.web.core.SessionIDInfor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class Widget
implements XMLable,
Component {
    public static final String XML_TAG = "Widget";
    protected boolean disabled;
    protected boolean invisible;
    protected int width = -1;
    protected int height = -1;
    protected int x = -1;
    protected int y = -1;
    protected Container parent;
    protected String widgetName;
    protected List listenerList;

    public abstract String getXType();

    public abstract boolean isEditor();

    public abstract String[] supportedEvents();

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setLocation(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void setBounds(Rectangle rectangle) {
        this.setX(rectangle.x);
        this.setY(rectangle.y);
        this.setWidth(rectangle.width);
        this.setHeight(rectangle.height);
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public void setWidgetName(String string) {
        this.widgetName = string;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean bl) {
        this.invisible = bl;
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        Object[] objectArray = this.supportedEvents();
        if (ArrayUtils.isEmpty(objectArray)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((String)objectArray[i]).equals(listener.getName())) continue;
            if (this.listenerList == null) {
                this.listenerList = new ArrayList();
            }
            this.listenerList.add(listener);
            return;
        }
    }

    public Listener getListener(int n) {
        return this.listenerList == null ? null : (Listener)this.listenerList.get(n);
    }

    public int getListenerSize() {
        return this.listenerList == null ? 0 : this.listenerList.size();
    }

    public void clearListeners() {
        if (this.listenerList != null) {
            this.listenerList.clear();
            this.listenerList = null;
        }
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        JSONArray jSONArray = new JSONArray();
        return jSONArray;
    }

    public Listener[] createListeners(Repository repository) {
        return this.listenerList == null ? new Listener[]{} : this.listenerList.toArray(new Listener[this.listenerList.size()]);
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        String[] stringArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", this.getXType());
        if (object != null) {
            jSONObject.put("value", this.value2Config(object));
        }
        if (this.width != -1) {
            jSONObject.put("width", this.width);
        }
        if (this.height != -1) {
            jSONObject.put("height", this.height);
        }
        if (this.x != -1) {
            jSONObject.put("top", this.x);
        }
        if (this.y != -1) {
            jSONObject.put("left", this.y);
        }
        jSONObject.put("widgetname", this.widgetName);
        jSONObject.put("fieldName", this.widgetName);
        jSONObject.put("disabled", this.disabled);
        jSONObject.put("invisible", this.invisible);
        if (repository.getSessionIDInfor() != null && (stringArray = ReportUtils.getWidgetImportedCssFromWorkBook(repository.getSessionIDInfor().getContextBook())).length > 0) {
            jSONObject.put("widgetCss", stringArray);
        }
        if ((stringArray = this.createJSONListener(repository)).length() > 0) {
            jSONObject.put("listeners", stringArray);
        }
        return jSONObject;
    }

    protected Object value2Config(Object object) {
        return object;
    }

    private JSONArray createJSONListener(Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Listener[] listenerArray = this.createListeners(repository);
        for (int i = 0; i < listenerArray.length; ++i) {
            jSONArray.put(listenerArray[i].createJSONConfig(repository));
        }
        return jSONArray;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearListeners();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = null;
            if (string.equals("Disable")) {
                this.disabled = Boolean.valueOf(xMLableReader.getElementValue());
            } else if (string.equals("WidgetName")) {
                this.widgetName = xMLableReader.getAttr("name");
            } else if (string.equals("WidgetAttr")) {
                this.disabled = Boolean.valueOf(xMLableReader.getAttr("disabled"));
                this.invisible = Boolean.valueOf(xMLableReader.getAttr("invisible"));
                string2 = xMLableReader.getAttr("width");
                if (string2 != null) {
                    this.width = Integer.parseInt(string2);
                }
                if ((string2 = xMLableReader.getAttr("height")) != null) {
                    this.height = Integer.parseInt(string2);
                }
            } else if (string.equals("Listener")) {
                Listener listener = new Listener();
                xMLableReader.readXMLObject(listener);
                this.addListener(listener);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotEmpty(this.widgetName)) {
            xMLPrintWriter.startTAG("WidgetName").attr("name", this.widgetName).end();
        }
        xMLPrintWriter.startTAG("WidgetAttr");
        if (this.disabled) {
            xMLPrintWriter.attr("disabled", this.disabled);
        }
        if (this.invisible) {
            xMLPrintWriter.attr("invisible", this.invisible);
        }
        if (this.width != -1) {
            xMLPrintWriter.attr("width", this.width);
        }
        if (this.height != -1) {
            xMLPrintWriter.attr("height", this.height);
        }
        xMLPrintWriter.end();
        if (this.listenerList != null) {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                ((Listener)this.listenerList.get(i)).writeXML(xMLPrintWriter);
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof Widget && ComparatorUtils.equals(((Widget)object).widgetName, this.widgetName) && this.disabled == ((Widget)object).disabled && this.invisible == ((Widget)object).invisible && this.width == ((Widget)object).width && this.height == ((Widget)object).height && ComparatorUtils.equals(this.listenerList, ((Widget)object).listenerList);
    }

    public Object clone() throws CloneNotSupportedException {
        Widget widget = (Widget)super.clone();
        if (this.listenerList != null) {
            widget.listenerList = new ArrayList();
            int n = this.listenerList.size();
            for (int i = 0; i < n; ++i) {
                widget.listenerList.add(((Listener)this.listenerList.get(i)).clone());
            }
        }
        return widget;
    }
}

