/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.FRContext;
import com.fr.base.XMLFileManager;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.util.ListMap;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.impl.NameWidget;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.report.web.ui.IconManager;
import com.fr.report.web.ui.Widget;
import com.fr.report.web.ui.WidgetConfig;
import java.util.Iterator;
import java.util.logging.Level;

public class WidgetManager
extends XMLFileManager
implements XMLable {
    public static final String XML_TAG = "WidgetManager";
    private ListMap nameWidgetConfigMap = new ListMap();
    private IconManager iconManager = null;

    public String fileName() {
        return "widgets.xml";
    }

    public Iterator getWidgetConfigNameIterator() {
        return this.nameWidgetConfigMap.keySet().iterator();
    }

    private WidgetConfig getStoredWidgetConfig(String string) {
        return (WidgetConfig)this.nameWidgetConfigMap.get(string);
    }

    private void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public IconManager getIconManager() {
        if (this.iconManager == null) {
            this.iconManager = new IconManager();
        }
        return this.iconManager;
    }

    public WidgetConfig getWidgetConfig(String string) {
        WidgetConfig widgetConfig = this.getStoredWidgetConfig(string);
        try {
            return widgetConfig == null ? null : (WidgetConfig)widgetConfig.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public void putWidgetConfig(String string, WidgetConfig widgetConfig) {
        if (widgetConfig == null) {
            this.nameWidgetConfigMap.remove(string);
        }
        this.nameWidgetConfigMap.put(string, widgetConfig);
    }

    public boolean renameWidgetConfig(String string, String string2) {
        if (!this.nameWidgetConfigMap.containsKey(string) || this.nameWidgetConfigMap.containsKey(string2)) {
            return false;
        }
        int n = this.nameWidgetConfigMap.indexOf(string);
        this.nameWidgetConfigMap.put(n, string2, this.nameWidgetConfigMap.get(string));
        return true;
    }

    public void removeWidgetConfig(String string) {
        this.nameWidgetConfigMap.remove(string);
    }

    public void clearAllWidgetConfig() {
        this.nameWidgetConfigMap.clear();
    }

    public static Widget widgetConfig2NameWidget(WidgetConfig widgetConfig) {
        WidgetManager widgetManager = FRContext.getWidgetManager();
        Iterator iterator = widgetManager.getWidgetConfigNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!ComparatorUtils.equals(widgetManager.getWidgetConfig(string), widgetConfig)) continue;
            return new NameWidget(string);
        }
        return null;
    }

    public static Widget widget2NameWidget(Widget widget) {
        WidgetManager widgetManager = FRContext.getWidgetManager();
        Iterator iterator = widgetManager.getWidgetConfigNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!ComparatorUtils.equals(widgetManager.getWidgetConfig(string).toWidget(), widget)) continue;
            return new NameWidget(string);
        }
        return widget;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearAllWidgetConfig();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = "";
            if (string.equals("XMLVersion")) {
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    SynchronizedVersion synchronizedVersion = SynchronizedVersion.getSynchronizedVersion(Thread.currentThread());
                    synchronizedVersion.setXmlVersionByString(string2);
                }
            } else if ("WidgetConfigMap".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("WidgetConfig")) {
                            String string = null;
                            String string2 = null;
                            string2 = xMLableReader.getAttr("name");
                            if (string2 != null) {
                                string = string2;
                            }
                            if (string == null) {
                                return;
                            }
                            WidgetConfig widgetConfig = DataXMLUtils.readXMLWidgetConfig(xMLableReader);
                            if (widgetConfig != null) {
                                WidgetManager.this.putWidgetConfig(string, widgetConfig);
                            }
                        }
                    }
                });
            } else if ("IM".equals(string)) {
                this.iconManager = new IconManager();
                xMLableReader.readXMLObject(this.iconManager);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        Iterator iterator = this.getWidgetConfigNameIterator();
        if (iterator.hasNext()) {
            xMLPrintWriter.startTAG("WidgetConfigMap");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                WidgetConfig widgetConfig = this.getStoredWidgetConfig(string);
                if (widgetConfig == null) continue;
                DataXMLUtils.writeXMLWidgetConfig(xMLPrintWriter, widgetConfig, string);
            }
            xMLPrintWriter.end();
        }
        if (this.iconManager != null) {
            this.iconManager.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

