/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.DirectWriteEditor;
import com.fr.web.Repository;

public abstract class WriteAbleRepeatEditor
extends DirectWriteEditor {
    private boolean removeRepeat = true;
    private String waterMark;

    public void setWaterMark(String string) {
        this.waterMark = string;
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public boolean isRemoveRepeat() {
        return this.removeRepeat;
    }

    public void setRemoveRepeat(boolean bl) {
        this.removeRepeat = bl;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        if (StringUtils.isNotBlank(this.getWaterMark())) {
            jSONObject.put("watermark", this.getWaterMark());
        }
        if (this.isRemoveRepeat()) {
            jSONObject.put("norepeat", true);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isCharacters()) {
            String string = xMLableReader.getTagName();
            if ("waterMark".equals(string)) {
                this.setWaterMark(xMLableReader.getContent());
            }
            if ("noRepeat".equals(string)) {
                this.setRemoveRepeat(Boolean.valueOf(xMLableReader.getContent()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.waterMark)) {
            xMLPrintWriter.startTAG("waterMark").textNode(this.waterMark).end();
        }
        if (!this.removeRepeat) {
            xMLPrintWriter.startTAG("noRepeat").textNode(String.valueOf(this.removeRepeat)).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof WriteAbleRepeatEditor && super.equals(object) && ComparatorUtils.equals(this.waterMark, ((WriteAbleRepeatEditor)object).waterMark) && this.removeRepeat == ((WriteAbleRepeatEditor)object).removeRepeat;
    }
}

