/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.impl;

import com.fr.base.Inter;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.IconManager;
import com.fr.report.web.ui.ToolBarButton;
import com.fr.report.web.ui.ToolBarMenuButton;
import com.fr.report.web.ui.impl.Excel;
import com.fr.report.web.ui.impl.ExcelO;
import com.fr.report.web.ui.impl.ExcelS;
import com.fr.report.web.ui.impl.PDF;
import com.fr.report.web.ui.impl.Word;
import com.fr.web.Repository;
import java.util.ArrayList;

public final class Export
extends ToolBarMenuButton {
    private boolean pdfAvailable = true;
    private boolean excelPAvailable = true;
    private boolean excelOAvailable = true;
    private boolean excelSAvailable = true;
    private boolean wordAvailable = true;

    public Export() {
        super(Inter.getLocText("Export"), IconManager.EXPORT.getName());
    }

    public boolean isPdfAvailable() {
        return this.pdfAvailable;
    }

    public void setPdfAvailable(boolean bl) {
        this.pdfAvailable = bl;
    }

    public boolean isWordAvailable() {
        return this.wordAvailable;
    }

    public void setWordAvailable(boolean bl) {
        this.wordAvailable = bl;
    }

    public boolean isExcelPAvailable() {
        return this.excelPAvailable;
    }

    public void setExcelPAvailable(boolean bl) {
        this.excelPAvailable = bl;
    }

    public boolean isExcelOAvailable() {
        return this.excelOAvailable;
    }

    public void setExcelOAvailable(boolean bl) {
        this.excelOAvailable = bl;
    }

    public boolean isExcelSAvailable() {
        return this.excelSAvailable;
    }

    public void setExcelSAvailable(boolean bl) {
        this.excelSAvailable = bl;
    }

    public Button[] createMenuItems() {
        ArrayList<ToolBarButton> arrayList = new ArrayList<ToolBarButton>();
        if (this.pdfAvailable) {
            arrayList.add(new PDF());
        }
        if (this.excelPAvailable) {
            arrayList.add(new Excel());
        }
        if (this.excelOAvailable) {
            arrayList.add(new ExcelO());
        }
        if (this.excelSAvailable) {
            arrayList.add(new ExcelS());
        }
        if (this.wordAvailable) {
            arrayList.add(new Word());
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    protected JSONObject createChildConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createChildConfig(repository);
        jSONObject.put("pdfAvailable", this.isPdfAvailable());
        jSONObject.put("excelPAvailable", this.isExcelPAvailable());
        jSONObject.put("excelOAvailable", this.isExcelOAvailable());
        jSONObject.put("excelSAvailable", this.isExcelSAvailable());
        jSONObject.put("wordAvailable", this.isWordAvailable());
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Buttons")) {
            String string = xMLableReader.getAttr("pdf");
            if (string != null) {
                this.setPdfAvailable(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("word")) != null) {
                this.setWordAvailable(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("excelP")) != null) {
                this.setExcelPAvailable(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("excelO")) != null) {
                this.setExcelOAvailable(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("excelS")) != null) {
                this.setExcelSAvailable(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Buttons").attr("pdf", this.pdfAvailable).attr("excelP", this.excelPAvailable).attr("excelO", this.excelOAvailable).attr("excelS", this.excelSAvailable).attr("word", this.wordAvailable).end();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Export)) {
            return false;
        }
        Export export = (Export)object;
        return super.equals(object) && this.isExcelPAvailable() == export.isExcelPAvailable() && this.isExcelOAvailable() == export.isExcelOAvailable() && this.isExcelSAvailable() == export.isExcelSAvailable() && this.isPdfAvailable() == export.isPdfAvailable() && this.isWordAvailable() == export.isWordAvailable();
    }
}

