/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.impl;

import com.fr.base.Inter;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.IconManager;
import com.fr.report.web.ui.ToolBarButton;
import com.fr.report.web.ui.ToolBarMenuButton;
import com.fr.report.web.ui.impl.AppletPrint;
import com.fr.report.web.ui.impl.FlashPrint;
import com.fr.report.web.ui.impl.PDFPrint;
import com.fr.report.web.ui.impl.ServerPrint;
import com.fr.web.Repository;
import java.util.ArrayList;

public final class Print
extends ToolBarMenuButton {
    private boolean pdfPrint = true;
    private boolean appletPrint = true;
    private boolean flashPrint = true;
    private boolean serverPrint = false;

    public Print() {
        super(Inter.getLocText("Print"), IconManager.PRINT.getName());
    }

    public boolean isPDFPrint() {
        return this.pdfPrint;
    }

    public void setPDFPrint(boolean bl) {
        this.pdfPrint = bl;
    }

    public boolean isAppletPrint() {
        return this.appletPrint;
    }

    public void setAppletPrint(boolean bl) {
        this.appletPrint = bl;
    }

    public boolean isFlashPrint() {
        return this.flashPrint;
    }

    public void setFlashPrint(boolean bl) {
        this.flashPrint = bl;
    }

    public boolean isServerPrint() {
        return this.serverPrint;
    }

    public void setServerPrint(boolean bl) {
        this.serverPrint = bl;
    }

    public Button[] createMenuItems() {
        ArrayList<ToolBarButton> arrayList = new ArrayList<ToolBarButton>();
        if (this.pdfPrint) {
            arrayList.add(new PDFPrint());
        }
        if (this.appletPrint) {
            arrayList.add(new AppletPrint());
        }
        if (this.flashPrint) {
            arrayList.add(new FlashPrint());
        }
        if (this.serverPrint) {
            arrayList.add(new ServerPrint());
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    protected JSONObject createChildConfig(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createChildConfig(repository);
        jSONObject.put("appletPrint", this.isAppletPrint());
        jSONObject.put("pdfPrint", this.isPDFPrint());
        jSONObject.put("flashPrint", this.isFlashPrint());
        jSONObject.put("serverPrint", this.isServerPrint());
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("PrintButtons")) {
            String string = xMLableReader.getAttr("pdfPrint");
            if (string != null) {
                this.setPDFPrint(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("appletPrint")) != null) {
                this.setAppletPrint(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("flashPrint")) != null) {
                this.setFlashPrint(Boolean.valueOf(string));
            }
            if ((string = xMLableReader.getAttr("serverPrint")) != null) {
                this.setServerPrint(Boolean.valueOf(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PrintButtons");
        if (!this.pdfPrint) {
            xMLPrintWriter.attr("pdfPrint", this.pdfPrint);
        }
        if (!this.appletPrint) {
            xMLPrintWriter.attr("appletPrint", this.appletPrint);
        }
        if (!this.flashPrint) {
            xMLPrintWriter.attr("flashPrint", this.flashPrint);
        }
        if (this.serverPrint) {
            xMLPrintWriter.attr("serverPrint", this.serverPrint);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Print)) {
            return false;
        }
        Print print = (Print)object;
        return super.equals(object) && this.isAppletPrint() == print.isAppletPrint() && this.isFlashPrint() == print.isPDFPrint() && this.isPDFPrint() == print.isPDFPrint() && this.isServerPrint() == print.isServerPrint();
    }
}

