/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.impl.page;

import com.fr.base.Style;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.report.DefaultCellElement;
import com.fr.report.Report;
import com.fr.report.WorkSheet;
import com.fr.report.core.ReportUtils;
import com.fr.report.js.JavaScriptImpl;
import com.fr.report.web.event.Listener;
import com.fr.report.web.ui.Composite;
import com.fr.report.web.ui.Label;
import com.fr.report.web.ui.ToolBarNumberEditor;
import com.fr.report.web.ui.WebContentUtils;
import com.fr.web.Repository;
import java.util.ArrayList;
import java.util.Arrays;

public class PageNavi
extends Composite {
    public Report getReport(Repository repository) {
        WorkSheet workSheet = new WorkSheet();
        workSheet.setHeader(0, null);
        workSheet.setFooter(0, null);
        int n = 40;
        if (ReportUtils.hasLayerReport4Template(repository.getSessionIDInfor().getContextBook())) {
            n = 60;
        }
        Style style = Style.DEFAULT_STYLE.deriveHorizontalAlignment(0);
        DefaultCellElement defaultCellElement = new DefaultCellElement(0, 0, 1, 1, new Integer(0));
        defaultCellElement.setWidget(new PageNumberEditor(n));
        defaultCellElement.setStyle(style);
        DefaultCellElement defaultCellElement2 = new DefaultCellElement(1, 0, 1, 1, new Integer(0));
        defaultCellElement2.setWidget(new PageNumberLabel());
        defaultCellElement2.setStyle(style);
        workSheet.addCellElement(defaultCellElement);
        workSheet.addCellElement(defaultCellElement2);
        workSheet.setColumnWidth(0, n + 5);
        workSheet.setColumnWidth(1, n);
        return workSheet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PageNavi)) {
            return false;
        }
        return super.equals(object);
    }

    private static class PageNumberLabel
    extends Label {
        private PageNumberLabel() {
        }

        public Listener[] createListeners(Repository repository) {
            return new Listener[]{new Listener(WebContentUtils.getContentPanel(repository), "afterload", new JavaScriptImpl(this.onContentPanelAfterLoad(repository)), false), new Listener(WebContentUtils.getContentPanel(repository), "tabchange", new JavaScriptImpl(this.onTabChange(repository)), false)};
        }

        private String onTabChange(Repository repository) {
            return TemplateUtils.render("if(${CP}.lgps[arguments[1]].reportTotalPage>0)this.setText(\"/\"+${CP}.lgps[arguments[1]].reportTotalPage); else this.setText(\"/\");", "CP", WebContentUtils.getContentPanel(repository));
        }

        private String onContentPanelAfterLoad(Repository repository) {
            return TemplateUtils.render("if(${CP}.rtype==='view'){if(${CP}.curLGP.reportTotalPage>0)this.setText(\"/\"+${CP}.curLGP.reportTotalPage); else this.setText(\"/\");}else{if(${CP}.reportTotalPage>0)this.setText(\"/\"+${CP}.reportTotalPage); else this.setText(\"/\");}", "CP", WebContentUtils.getContentPanel(repository));
        }
    }

    private static class PageNumberEditor
    extends ToolBarNumberEditor {
        private int width;

        public PageNumberEditor(int n) {
            this.setAllowDecimals(false);
            this.setAllowNegative(false);
            this.setDisabled(true);
            this.width = n;
        }

        public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
            return super.createJSONConfig(object, repository).put("style", "text-align:center;width:" + this.width);
        }

        public Listener[] createListeners(Repository repository) {
            ArrayList<Listener> arrayList = new ArrayList<Listener>();
            arrayList.addAll(Arrays.asList(super.createListeners(repository)));
            arrayList.add(new Listener("afteredit", new JavaScriptImpl(TemplateUtils.render("if(e.keyCode == $.ui.keyCode.ENTER){${CP}.gotoPage(this.getValue() - 1 + 1)}", "CP", WebContentUtils.getContentPanel(repository)))));
            if ("view".equals(repository.getSessionIDInfor().getPolicy().panelType())) {
                arrayList.add(new Listener(WebContentUtils.getContentPanel(repository), "tabchange", new JavaScriptImpl(this.onTabChange(repository)), false));
            }
            return arrayList.toArray(new Listener[arrayList.size()]);
        }

        private String onTabChange(Repository repository) {
            return TemplateUtils.render("this.setValue((${CP}.lgps[arguments[1]].currentPageIndex));", "CP", WebContentUtils.getContentPanel(repository));
        }

        protected String onContentPanelAfterLoad(Repository repository) {
            return super.onContentPanelAfterLoad(repository) + ";this.$editorComponent.attr('disabled', false);" + TemplateUtils.render("if(${CP}.rtype==='view'){this.setValue((${CP}.curLGP.currentPageIndex));}else{this.setValue((${CP}.currentPageIndex));}", "CP", WebContentUtils.getContentPanel(repository));
        }
    }
}

