/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.impl.write;

import com.fr.base.ArrayUtils;
import com.fr.base.ColumnRow;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.js.JavaScriptImpl;
import com.fr.report.web.event.Listener;
import com.fr.report.web.ui.Button;
import com.fr.report.web.ui.WebContentUtils;
import com.fr.web.Repository;

public class AppendRowButton
extends Button {
    private ColumnRow fixCell = null;
    private int count = 1;

    public ColumnRow getFixCell() {
        return this.fixCell;
    }

    public void setFixCell(ColumnRow columnRow) {
        this.fixCell = columnRow;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public Listener[] createListeners(Repository repository) {
        return (Listener[])ArrayUtils.addAll(super.createListeners(repository), new Listener[]{new Listener("click", new JavaScriptImpl(WebContentUtils.getContentPanel(repository) + ".appendReportRow(this.options.location, this.options.reportIndex," + this.count + ")"))});
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        String string = null;
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (string2.equals("FixCell")) {
                int n = Integer.parseInt(xMLableReader.getAttr("row"));
                int n2 = Integer.parseInt(xMLableReader.getAttr("col"));
                this.setFixCell(ColumnRow.valueOf(n2, n));
            } else if (string2.equals("count") && (string = xMLableReader.getElementValue()) != null) {
                this.setCount(Integer.parseInt(string));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.fixCell != null) {
            xMLPrintWriter.startTAG("FixCell").attr("row", this.fixCell.row).attr("col", this.fixCell.column).end();
        }
        if (this.count != 1) {
            xMLPrintWriter.startTAG("count").textNode(String.valueOf(this.count)).end();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AppendRowButton)) {
            return false;
        }
        AppendRowButton appendRowButton = (AppendRowButton)object;
        return super.equals(object) && ComparatorUtils.equals(this.getFixCell(), appendRowButton.getFixCell()) && this.getCount() == appendRowButton.getCount();
    }
}

