/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.layout;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.web.ui.Widget;
import com.fr.report.web.ui.layout.Layout2;
import com.fr.web.Repository;

public class BorderLayout
extends Layout2 {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private Widget north;
    private Widget south;
    private Widget east;
    private Widget west;
    private Widget center;

    public void addLayoutWidget(Widget widget, Object object) {
        super.addLayoutWidget(widget, object);
        if (NORTH.equals(object)) {
            this.north = widget;
        } else if (SOUTH.equals(object)) {
            this.south = widget;
        } else if (EAST.equals(object)) {
            this.east = widget;
        } else {
            this.center = widget;
        }
    }

    public void removeLayoutWidget(Widget widget) {
        super.removeLayoutWidget(widget);
        if (ComparatorUtils.equals(this.north, widget)) {
            this.north = null;
        } else if (ComparatorUtils.equals(this.south, widget)) {
            this.south = null;
        } else if (ComparatorUtils.equals(this.east, widget)) {
            this.east = null;
        } else if (ComparatorUtils.equals(this.west, widget)) {
            this.west = null;
        } else if (ComparatorUtils.equals(this.center, widget)) {
            this.center = null;
        }
    }

    public void removeAll() {
        super.removeAll();
        this.north = null;
        this.south = null;
        this.east = null;
        this.west = null;
        this.center = null;
    }

    public String getXType() {
        return "borderlayout";
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("items", this.createJSONItems(object, repository));
        return jSONObject;
    }

    protected JSONArray createJSONItems(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject;
        JSONArray jSONArray = new JSONArray();
        if (this.north != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "north");
            jSONObject.put("height", this.north.getHeight());
            jSONObject.put("el", this.north.createJSONConfig(object, repository));
            jSONArray.put(jSONObject);
        }
        if (this.south != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "south");
            jSONObject.put("height", this.south.getHeight());
            jSONObject.put("el", this.south.createJSONConfig(object, repository));
            jSONArray.put(jSONObject);
        }
        if (this.east != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "east");
            jSONObject.put("width", this.east.getWidth());
            jSONObject.put("el", this.east.createJSONConfig(object, repository));
            jSONArray.put(jSONObject);
        }
        if (this.west != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", "west");
            jSONObject.put("width", this.west.getWidth());
            jSONObject.put("el", this.west.createJSONConfig(object, repository));
            jSONArray.put(jSONObject);
        }
        jSONObject = new JSONObject();
        jSONObject.put("region", "center");
        jSONObject.put("el", this.center.createJSONConfig(object, repository));
        jSONArray.put(jSONObject);
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(NORTH)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        BorderLayout.this.north = (Widget)ReportXMLUtils.readXMLable(xMLableReader);
                        BorderLayout.this.widgetList.add(BorderLayout.this.north);
                    }
                });
            } else if (string.equals(SOUTH)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        BorderLayout.this.south = (Widget)ReportXMLUtils.readXMLable(xMLableReader);
                        BorderLayout.this.widgetList.add(BorderLayout.this.south);
                    }
                });
            } else if (string.equals(EAST)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        BorderLayout.this.east = (Widget)ReportXMLUtils.readXMLable(xMLableReader);
                        BorderLayout.this.widgetList.add(BorderLayout.this.east);
                    }
                });
            } else if (string.equals(WEST)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        BorderLayout.this.west = (Widget)ReportXMLUtils.readXMLable(xMLableReader);
                        BorderLayout.this.widgetList.add(BorderLayout.this.west);
                    }
                });
            } else if (string.equals(CENTER)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        BorderLayout.this.center = (Widget)ReportXMLUtils.readXMLable(xMLableReader);
                        BorderLayout.this.widgetList.add(BorderLayout.this.center);
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.north != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.north, NORTH);
        }
        if (this.south != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.south, SOUTH);
        }
        if (this.center != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.center, CENTER);
        }
        if (this.west != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.west, WEST);
        }
        if (this.east != null) {
            ReportXMLUtils.writeXMLable(xMLPrintWriter, this.east, EAST);
        }
    }
}

