/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.layout;

import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.layout.Layout2;
import com.fr.web.Repository;

public class GridLayout
extends Layout2 {
    private int cols;
    private int rows;

    public GridLayout() {
        this(1, 0);
    }

    public GridLayout(int n, int n2) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("column and row cannot be zero at time");
        }
        this.cols = n;
        this.rows = n2;
    }

    public JSONObject createJSONConfig(Object object, Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(object, repository);
        jSONObject.put("rows", this.rows);
        jSONObject.put("cols", this.cols);
        jSONObject.put("items", this.createJSONItems(object, repository));
        return jSONObject;
    }

    public String getXType() {
        return "gridlayout";
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("GLAttr")) {
            String string2 = xMLableReader.getAttr("rows");
            if (string2 != null) {
                this.rows = Integer.parseInt(string2);
            }
            if ((string2 = xMLableReader.getAttr("cols")) != null) {
                this.cols = Integer.parseInt(string2);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.rows != 1 && this.cols != 0) {
            xMLPrintWriter.startTAG("GLAttr").attr("rows", this.rows).attr("cols", this.cols).end();
        }
    }
}

