/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.ui.reg;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.web.ui.reg.AbstractReg;
import com.fr.util.Utils;

public class LengthReg
extends AbstractReg {
    public static final String XML_TAG = "LenReg";
    private int minLen = 0;
    private int maxLen = 13;

    public int getMinLen() {
        return this.minLen;
    }

    public void setMinLen(int n) {
        this.minLen = n;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    public String toRegText() {
        return "^.{" + this.minLen + "," + this.maxLen + "}$";
    }

    public boolean equals(Object object) {
        return object instanceof LengthReg && ((LengthReg)object).minLen == this.minLen && ((LengthReg)object).maxLen == this.maxLen;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            String string2 = xMLableReader.getAttr("min");
            if (string2 != null) {
                this.minLen = Utils.string2Number(string2).intValue();
            }
            if ((string2 = xMLableReader.getAttr("max")) != null) {
                this.maxLen = Utils.string2Number(string2).intValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.minLen != 0 || this.maxLen != 13) {
            xMLPrintWriter.startTAG(XML_TAG);
            xMLPrintWriter.attr("min", this.minLen);
            xMLPrintWriter.attr("max", this.maxLen);
            xMLPrintWriter.end();
        }
    }
}

