/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.Report;
import com.fr.report.TableDataSource;
import com.fr.report.script.Calculator;
import com.fr.report.write.MismatchException;
import com.fr.report.write.Submiter;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractSubmiter
implements Submiter {
    private String condition;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        if (!StringUtils.isBlank(this.condition)) {
            Calculator calculator = Calculator.createStaticCalculator();
            calculator.setCurrentReport(report);
            calculator.setCurrentTableDataSource(tableDataSource);
            Object object = calculator.eval(this.condition);
            calculator.release();
            if (!Boolean.TRUE.equals(object)) {
                FRContext.getLogger().log(Level.INFO, "The condition " + this.condition + " is non-compliance");
                throw new MismatchException();
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Condition".equals(xMLableReader.getTagName())) {
            this.setCondition(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.condition)) {
            xMLPrintWriter.startTAG("Condition").textNode(this.condition).end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

