/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLableReader;
import com.fr.data.DBManipulation;
import com.fr.data.core.db.dml.Table;
import com.fr.report.Report;
import com.fr.report.TableDataSource;
import com.fr.report.core.FormException;
import com.fr.report.core.FormReport;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.write.AbstractSubmiter;
import com.fr.report.write.MismatchException;
import com.fr.report.write.config.ColumnConfig;
import com.fr.report.write.config.DMLConfig;
import com.fr.report.write.config.IntelliDMLConfig;
import java.util.Map;

public class BuiltInSQLSubmiter
extends AbstractSubmiter {
    private DBManipulation dbManipulation;

    public DBManipulation getDBManipulation() {
        return this.dbManipulation;
    }

    public void setDBManipulation(DBManipulation dBManipulation) {
        this.dbManipulation = dBManipulation;
    }

    public String getDBName() {
        return this.dbManipulation == null ? null : this.dbManipulation.getDBName();
    }

    public void setDBName(String string) {
        if (this.dbManipulation == null) {
            this.dbManipulation = new DBManipulation();
        }
        this.dbManipulation.setDBName(string);
    }

    public DMLConfig getDmlConfig() {
        return this.dbManipulation == null ? null : this.dbManipulation.getDmlConfig();
    }

    public void setDmlConfig(DMLConfig dMLConfig) {
        if (this.dbManipulation == null) {
            this.dbManipulation = new DBManipulation();
        }
        this.dbManipulation.setDmlConfig(dMLConfig);
    }

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        try {
            super.execute(report, tableDataSource, map);
        }
        catch (MismatchException mismatchException) {
            return;
        }
        if (!(report instanceof FormReport)) {
            throw new FormException("Application can only submit the data of form report.");
        }
        Calculator calculator = Calculator.createCalculator();
        calculator.setCurrentReport(report);
        calculator.setCurrentTableDataSource(tableDataSource);
        calculator.pushNameSpace(ParameterMapNameSpace.create(map));
        this.dbManipulation.commit2db(calculator);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.dbManipulation = new DBManipulation();
        }
        this.dbManipulation.readXML(xMLableReader);
    }

    public void readOldXML(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                Object object;
                String string;
                if (xMLableReader.isAttr()) {
                    string = xMLableReader.getAttr("dsName");
                    if (string != null) {
                        BuiltInSQLSubmiter.this.setDBName(string);
                    }
                    object = new IntelliDMLConfig();
                    BuiltInSQLSubmiter.this.setDmlConfig((DMLConfig)object);
                    string = xMLableReader.getAttr("tableName");
                    if (string != null) {
                        ((DMLConfig)object).setTable(new Table(string));
                    }
                }
                if (xMLableReader.isChildNode() && "Column".equals(xMLableReader.getTagName())) {
                    DMLConfig dMLConfig;
                    object = null;
                    boolean bl = false;
                    string = xMLableReader.getAttr("name");
                    if (string != null) {
                        object = string;
                    }
                    if ((string = xMLableReader.getAttr("isKey")) != null) {
                        bl = Boolean.valueOf(string);
                    }
                    if ((dMLConfig = BuiltInSQLSubmiter.this.getDmlConfig()) == null) {
                        dMLConfig = new IntelliDMLConfig();
                        BuiltInSQLSubmiter.this.setDmlConfig(dMLConfig);
                    }
                    dMLConfig.addColumnConfig(new ColumnConfig((String)object, DBManipulation.readColumnValue(xMLableReader), bl, false));
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.dbManipulation != null) {
            this.dbManipulation.writeXML(xMLPrintWriter);
        }
    }

    public String toString() {
        return this.dbManipulation == null ? "" : this.dbManipulation.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        BuiltInSQLSubmiter builtInSQLSubmiter = (BuiltInSQLSubmiter)super.clone();
        if (this.dbManipulation != null) {
            builtInSQLSubmiter.dbManipulation = (DBManipulation)this.dbManipulation.clone();
        }
        return builtInSQLSubmiter;
    }
}

