/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.core.DataXMLUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.report.Report;
import com.fr.report.TableDataSource;
import com.fr.report.core.FormException;
import com.fr.report.write.AbstractSubmiter;
import com.fr.report.write.MismatchException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Map;

public class FreeSQLSubmiter
extends AbstractSubmiter {
    private String dbName;
    private String sql;

    public String getDBName() {
        return this.dbName;
    }

    public void setDBName(String string) {
        this.dbName = string;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String string) {
        this.sql = string;
    }

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        try {
            super.execute(report, tableDataSource, map);
        }
        catch (MismatchException mismatchException) {
            return;
        }
        if (this.dbName == null || this.sql == null) {
            return;
        }
        NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(this.dbName);
        Connection connection = null;
        try {
            connection = nameDatabaseConnection.createConnection();
        }
        catch (Exception exception) {
            if (connection != null) {
                DBUtils.rollback(connection);
            }
            throw new FormException("can't connect to Database: " + this.dbName + "\n" + exception.getMessage(), exception);
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(this.sql);
            return;
        }
        catch (Exception exception) {
            if (connection != null) {
                DBUtils.rollback(connection);
            }
            throw new FormException("submiter error happens.\n" + exception.getMessage(), exception);
        }
        finally {
            if (connection != null) {
                DBUtils.closeConnection(connection);
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("DBName".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setDBName(string2);
                }
            } else if ("SQL".equals(string)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setSQL(string3);
                }
            } else if ("Database".equals(string)) {
                NameDatabaseConnection nameDatabaseConnection = (NameDatabaseConnection)DataXMLUtils.readXMLConnection(xMLableReader);
                this.setDBName(nameDatabaseConnection.getName());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DBName").textNode(this.getDBName()).end().startTAG("SQL").textNode(this.getSQL()).end();
        super.writeXML(xMLPrintWriter);
    }
}

