/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.Formula;
import com.fr.report.io.xml.ReportXMLUtils;

public class ValueVerifier
implements XMLable {
    public static final String XML_TAG = "VV";
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private Formula formula = null;
    private String message = "";
    private int type = 0;

    public ValueVerifier() {
    }

    public ValueVerifier(String string, String string2) {
        this.setFormula(new Formula(string));
        this.setMessage(string2);
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("O".equals(string)) {
                Object object = ReportXMLUtils.readObject(xMLableReader);
                if (object instanceof Formula) {
                    this.setFormula((Formula)object);
                }
            } else if ("Message".equals(string)) {
                this.setMessage(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.formula != null) {
            ReportXMLUtils.writeObject(xMLPrintWriter, this.formula);
            if (!StringUtils.isEmpty(this.message)) {
                xMLPrintWriter.startTAG("Message").textNode(this.message).end();
            }
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.getType() == 0) {
            stringBuffer.append(Inter.getLocText("Success"));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            stringBuffer.append(Inter.getLocText("Expression"));
            stringBuffer.append(": ");
            stringBuffer.append(this.formula);
            return stringBuffer.toString();
        }
        if (this.getType() == 1) {
            stringBuffer.append(Inter.getLocText("Error"));
        } else if (this.getType() == 2) {
            stringBuffer.append(Inter.getLocText("Warning"));
        }
        stringBuffer.append("]");
        stringBuffer.append(" ");
        stringBuffer.append(Inter.getLocText("Expression"));
        stringBuffer.append(": ");
        stringBuffer.append(this.formula);
        stringBuffer.append("  ");
        stringBuffer.append(Inter.getLocText("Message"));
        stringBuffer.append(": ");
        stringBuffer.append(this.message);
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ValueVerifier valueVerifier = (ValueVerifier)super.clone();
        valueVerifier.setFormula((Formula)this.formula.clone());
        return valueVerifier;
    }
}

