/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write.config;

import com.fr.base.ArrayUtils;
import com.fr.base.ColumnRow;
import com.fr.base.ColumnRowRelated;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;

public class ColumnConfig
implements XMLable {
    public static final String XML_TAG = "ColumnConfig";
    private String name;
    private Object value;
    private boolean isKey;
    private boolean skipUnmodified;

    public ColumnConfig() {
    }

    public ColumnConfig(String string, Object object, boolean bl, boolean bl2) {
        this.name = string;
        this.value = object;
        this.isKey = bl;
        this.skipUnmodified = bl2;
    }

    public String getColumnName() {
        return this.name;
    }

    public void setColumnName(String string) {
        this.name = string;
    }

    public Object getColumnValue() {
        return this.value;
    }

    public boolean isModified(Calculator calculator) {
        Object[] objectArray;
        if (this.value instanceof ColumnRowRelated && !ArrayUtils.isEmpty(objectArray = ((ColumnRowRelated)this.value).getRelatedColumnRows())) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                Object object2 = calculator.resolveCellElementAttribute((ColumnRow)objectArray[i], CellElementAttribute.INSERT_NEW);
                if (object2 != null) {
                    return true;
                }
                Object object3 = calculator.resolveCellElementAttribute((ColumnRow)objectArray[i], CellElementAttribute.ORIGINAL);
                if (ComparatorUtils.equals(object3, object = calculator.resolveVariable(objectArray[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDeleted(Calculator calculator) {
        Object[] objectArray;
        if (this.value instanceof ColumnRowRelated && !ArrayUtils.isEmpty(objectArray = ((ColumnRowRelated)this.value).getRelatedColumnRows())) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = calculator.resolveCellElementAttribute((ColumnRow)objectArray[i], CellElementAttribute.DEL);
                if (!this.trueOrFalse(object)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean trueOrFalse(Object object) {
        if (object != null && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.trueOrFalse(objectArray[i])) continue;
                return true;
            }
            return false;
        }
        return Boolean.TRUE.equals(object);
    }

    public void setColumnValue(Object object) {
        this.value = object;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public boolean isSkipUnmodified() {
        return this.skipUnmodified;
    }

    public void setSkipUnmodified(boolean bl) {
        this.skipUnmodified = bl;
    }

    public String toString() {
        return (this.isKey ? "* " : "") + this.name + ":" + this.value;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isAttr()) {
            string = xMLableReader.getAttr("name");
            if (string != null) {
                this.name = string;
            }
            if ((string = xMLableReader.getAttr("isKey")) != null) {
                this.isKey = Boolean.valueOf(string);
            }
            if ((string = xMLableReader.getAttr("skipUnmodified")) != null) {
                this.skipUnmodified = Boolean.valueOf(string);
            }
        }
        if (xMLableReader.isChildNode()) {
            Object object;
            String string2 = xMLableReader.getTagName();
            if ("ColumnRow".endsWith(string2)) {
                int n = 0;
                int n2 = 0;
                string = xMLableReader.getAttr("column");
                if (string != null) {
                    n = Integer.parseInt(string);
                }
                if ((string = xMLableReader.getAttr("row")) != null) {
                    n2 = Integer.parseInt(string);
                }
                object = ColumnRow.valueOf(n, n2);
            } else {
                object = "Parameter".equals(string2) ? ReportXMLUtils.readParameter(xMLableReader) : ("Object".equals(string2) || "O".equals(string2) ? ReportXMLUtils.readObject(xMLableReader) : "");
            }
            this.setColumnValue(object);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.name).attr("isKey", this.isKey).attr("skipUnmodified", this.skipUnmodified);
        if (this.value instanceof ColumnRow) {
            ColumnRow columnRow = (ColumnRow)this.value;
            BaseXMLUtils.writeColumnRow(xMLPrintWriter, columnRow);
        } else if (this.value instanceof Parameter) {
            ReportXMLUtils.writeParameter(xMLPrintWriter, (Parameter)this.value);
        } else {
            ReportXMLUtils.writeObject(xMLPrintWriter, this.value);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColumnConfig)) {
            return false;
        }
        ColumnConfig columnConfig = (ColumnConfig)object;
        return columnConfig.isKey == this.isKey && columnConfig.skipUnmodified == this.skipUnmodified && columnConfig.name.equals(this.name) && columnConfig.value.equals(this.value);
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnConfig columnConfig = (ColumnConfig)super.clone();
        return columnConfig;
    }
}

