/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write.config;

import com.fr.base.ColumnRow;
import com.fr.base.ColumnRowRelated;
import com.fr.base.FRContext;
import com.fr.base.XMLable;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.Mapper;
import com.fr.base.core.antlr.ANTLRException;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.data.DBFeedback;
import com.fr.data.NameSubmitJob;
import com.fr.data.SubmitJob;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.ColumnInformation;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.FormReport;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.script.core.FArray;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.report.write.config.ColumnConfig;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class DMLConfig
implements XMLable,
ColumnRowRelated {
    public static final String XML_TAG = "DMLConfig";
    protected Table table = null;
    private List columnConfigList = new ArrayList();
    protected List submitJobList = new ArrayList();
    private transient ColumnInformation[] columnInformations = null;
    private static Mapper toName = new Mapper(){

        public Object map(int n, Object object, List list) {
            return ((ColumnConfig)object).getColumnName();
        }
    };
    private static Mapper toValue = new Mapper(){

        public Object map(int n, Object object, List list) {
            return ((ColumnConfig)object).getColumnValue();
        }
    };

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addColumnConfig(ColumnConfig columnConfig) {
        this.columnConfigList.add(columnConfig);
    }

    public int getColumnConfigCount() {
        return this.columnConfigList.size();
    }

    public ColumnConfig getColumnConfig(int n) {
        return (ColumnConfig)this.columnConfigList.get(n);
    }

    public void clearColumnConfigs() {
        this.columnConfigList.clear();
    }

    public void addSubmitJob(NameSubmitJob nameSubmitJob) {
        this.submitJobList.add(nameSubmitJob);
    }

    public int getSubmitJobCount() {
        return this.submitJobList.size();
    }

    public NameSubmitJob getSubmitJob(int n) {
        return (NameSubmitJob)this.submitJobList.get(n);
    }

    public void clearSubmitJobs() {
        this.submitJobList.clear();
    }

    public ColumnRow[] getRelatedColumnRows() {
        HashSet<ColumnRow> hashSet = new HashSet<ColumnRow>();
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            Object object = columnConfig.getColumnValue();
            if (object instanceof ColumnRowRelated) {
                hashSet.addAll(Arrays.asList(((ColumnRowRelated)object).getRelatedColumnRows()));
                continue;
            }
            if (!(object instanceof String) || !((String)object).startsWith("=")) continue;
            try {
                hashSet.addAll(Arrays.asList(Calculator.relatedColumnRowArray((String)object)));
                continue;
            }
            catch (ANTLRException aNTLRException) {
                FRContext.getLogger().log(Level.WARNING, aNTLRException.getMessage(), aNTLRException);
            }
        }
        return hashSet.toArray(new ColumnRow[0]);
    }

    public void execute(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection);
        calculator.extract(this.getRelatedColumnRows(), calculator.getCurrentColumnRow(), extractionSubmitter);
    }

    public DBFeedback executeAndFeedback(Connection connection, Calculator calculator) throws Exception {
        ExtractionSubmitter extractionSubmitter = new ExtractionSubmitter(connection, new DBFeedback());
        calculator.extract(this.getRelatedColumnRows(), calculator.getCurrentColumnRow(), extractionSubmitter);
        return extractionSubmitter.getFeedback();
    }

    private DMLColumnValues[] rebuildDMLConfig(Calculator calculator) throws CloneNotSupportedException {
        Object[] objectArray = new Object[this.getColumnConfigCount()];
        int n = this.getColumnConfigCount();
        for (int i = 0; i < n; ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            objectArray[i] = this.calculateColumnValue2DML(columnConfig.getColumnValue(), calculator);
        }
        return this.extractByValues2Column(objectArray);
    }

    private Object calculateColumnValue2DML(Object object, Calculator calculator) {
        if (object instanceof Parameter) {
            try {
                return calculator.eval(((Parameter)object).getName());
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                return null;
            }
        }
        if (object instanceof ColumnRow) {
            return calculator.resolveVariable(object);
        }
        if (object instanceof Formula) {
            try {
                return calculator.eval(((Formula)object).getContent());
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
                return null;
            }
        }
        if (object instanceof String && calculator.getAttribute("$$_NEWCHAR") != null && calculator.getAttribute("$$_ORIGINALCHAR") != null) {
            try {
                return new String(((String)object).getBytes((String)calculator.getAttribute("$$_NEWCHAR")), (String)calculator.getAttribute("$$_ORIGINALCHAR"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRContext.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        return object;
    }

    protected DMLColumnValues[] extractByValues2Column(Object[] objectArray) throws CloneNotSupportedException {
        DMLColumnValues dMLColumnValues = new DMLColumnValues();
        ArrayList<DMLColumnValues> arrayList = new ArrayList<DMLColumnValues>();
        arrayList.add(dMLColumnValues);
        this.addDMLConfig2List(dMLColumnValues, 0, objectArray, arrayList);
        return arrayList.toArray(new DMLColumnValues[arrayList.size()]);
    }

    private void addDMLConfig2List(DMLColumnValues dMLColumnValues, int n, Object[] objectArray, List list) throws CloneNotSupportedException {
        if (n >= objectArray.length) {
            return;
        }
        Object object = objectArray[n];
        if (object instanceof FArray) {
            int n2 = ((FArray)object).length();
            for (int i = 0; i < n2; ++i) {
                DMLColumnValues dMLColumnValues2 = dMLColumnValues;
                Object object2 = ((FArray)object).elementAt(i);
                if (i > 0) {
                    dMLColumnValues2 = (DMLColumnValues)dMLColumnValues2.clone();
                    list.add(dMLColumnValues2);
                }
                dMLColumnValues2.set(n, object2);
                this.addDMLConfig2List(dMLColumnValues2, n + 1, objectArray, list);
            }
        } else {
            dMLColumnValues.set(n, object);
            this.addDMLConfig2List(dMLColumnValues, n + 1, objectArray, list);
        }
    }

    protected abstract void dmlSubmit(Connection var1, Calculator var2, Object[] var3, Map var4) throws SQLException;

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearColumnConfigs();
            this.clearSubmitJobs();
        } else if (xMLableReader.isChildNode()) {
            SubmitJob submitJob;
            String string = xMLableReader.getTagName();
            if ("Table".equals(string)) {
                this.table = new Table();
                xMLableReader.readXMLObject(this.table);
            } else if ("ColumnConfig".equals(string)) {
                ColumnConfig columnConfig = new ColumnConfig();
                xMLableReader.readXMLObject(columnConfig);
                this.addColumnConfig(columnConfig);
            } else if ("NameSubmitJob".equals(string)) {
                NameSubmitJob nameSubmitJob = new NameSubmitJob();
                xMLableReader.readXMLObject(nameSubmitJob);
                this.addSubmitJob(nameSubmitJob);
            } else if ("SubmitJob".equals(string) && (submitJob = ReportXMLUtils.readSubmitJob(xMLableReader)) != null) {
                NameSubmitJob nameSubmitJob = new NameSubmitJob();
                nameSubmitJob.setSubmitJob(submitJob);
                this.addSubmitJob(nameSubmitJob);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        if (this.table != null) {
            this.table.writeXML(xMLPrintWriter);
        }
        int n2 = this.getColumnConfigCount();
        for (n = 0; n < n2; ++n) {
            ColumnConfig columnConfig = this.getColumnConfig(n);
            if (columnConfig == null) continue;
            columnConfig.writeXML(xMLPrintWriter);
        }
        n2 = this.getSubmitJobCount();
        for (n = 0; n < n2; ++n) {
            this.getSubmitJob(n).writeXML(xMLPrintWriter);
        }
    }

    protected Where generateWhere(Connection connection, Calculator calculator, Object[] objectArray) {
        Where where = null;
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (!columnConfig.isKey()) continue;
            if (where == null) {
                where = new Where();
            }
            String string = columnConfig.getColumnName();
            int n = this.getColumnType(string, connection);
            where.addColumn(string, n, 0, objectArray[i]);
        }
        return where;
    }

    protected int getColumnType(String string, Connection connection) {
        this.checkColumnTypes(connection);
        for (int i = 0; i < this.columnInformations.length; ++i) {
            if (!string.equalsIgnoreCase(this.columnInformations[i].getColumnName())) continue;
            return this.columnInformations[i].getColumnType();
        }
        return 0;
    }

    private void checkColumnTypes(Connection connection) {
        if (this.columnInformations == null) {
            String string = DataUtils.createSelectSQL(this.table);
            try {
                this.columnInformations = DBUtils.checkInColumnInformation(connection, string, 0);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                this.columnInformations = new ColumnInformation[0];
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getColumnConfigCount();
        if (n > 0) {
            stringBuffer.append("(").append(BaseCoreUtils.join(BaseCoreUtils.map(this.columnConfigList, toName), ", ")).append(") values(").append(BaseCoreUtils.join(BaseCoreUtils.map(this.columnConfigList, toValue), ", ")).append(")");
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        DMLConfig dMLConfig = (DMLConfig)super.clone();
        if (this.table != null) {
            dMLConfig.table = (Table)this.table.clone();
        }
        if (this.columnConfigList != null) {
            dMLConfig.columnConfigList = new ArrayList();
            for (n = 0; n < this.getColumnConfigCount(); ++n) {
                dMLConfig.addColumnConfig((ColumnConfig)this.getColumnConfig(n).clone());
            }
        }
        if (this.submitJobList != null) {
            dMLConfig.submitJobList = new ArrayList();
            for (n = 0; n < this.submitJobList.size(); ++n) {
                dMLConfig.submitJobList.add(this.getSubmitJob(n).clone());
            }
        }
        return dMLConfig;
    }

    protected static class DMLColumnValues
    implements Serializable,
    Cloneable {
        private ArrayList values = new ArrayList();

        protected DMLColumnValues() {
        }

        protected void set(int n, Object object) {
            while (n >= this.values.size()) {
                this.values.add(null);
            }
            this.values.set(n, object);
        }

        protected Object get(int n) {
            return this.values.get(n);
        }

        protected int size() {
            return this.values.size();
        }

        protected Object[] toArray() {
            return this.values.toArray();
        }

        public Object clone() throws CloneNotSupportedException {
            DMLColumnValues dMLColumnValues = (DMLColumnValues)super.clone();
            dMLColumnValues.values = new ArrayList();
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                dMLColumnValues.set(i, BaseCoreUtils.cloneObject(this.get(i)));
            }
            return dMLColumnValues;
        }
    }

    private class ExtractionSubmitter
    implements FormReport.Action {
        private DBFeedback feedback;
        private Connection conn;

        ExtractionSubmitter(Connection connection) {
            this(connection, null);
        }

        ExtractionSubmitter(Connection connection, DBFeedback dBFeedback) {
            this.conn = connection;
            this.feedback = dBFeedback;
        }

        public DBFeedback getFeedback() {
            return this.feedback;
        }

        public void run(int n, Calculator calculator) throws Exception {
            HashMap hashMap = null;
            if (this.feedback != null || DMLConfig.this.getSubmitJobCount() > 0) {
                hashMap = new HashMap();
            }
            DMLColumnValues[] dMLColumnValuesArray = DMLConfig.this.rebuildDMLConfig(calculator);
            for (int i = 0; i < dMLColumnValuesArray.length; ++i) {
                DMLConfig.this.dmlSubmit(this.conn, calculator, dMLColumnValuesArray[i].toArray(), hashMap);
                if (this.feedback != null) {
                    this.feedback.addFeedback(hashMap);
                }
                ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(hashMap);
                calculator.pushNameSpace(parameterMapNameSpace);
                int n2 = DMLConfig.this.getSubmitJobCount();
                for (int j = 0; j < n2; ++j) {
                    DMLConfig.this.getSubmitJob(j).getSubmitJob().doJob(calculator);
                }
                calculator.removeNameSpace(parameterMapNameSpace);
            }
        }
    }
}

