/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write.config;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.report.script.Calculator;
import com.fr.report.write.config.ColumnConfig;
import com.fr.report.write.config.DMLConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class IntelliDMLConfig
extends DMLConfig {
    public void dmlSubmit(Connection connection, Calculator calculator, Object[] objectArray, Map map) throws SQLException {
        InsertOrUpdate insertOrUpdate;
        int n = this.getColumnConfigCount();
        if (n == 0 || this.table == null) {
            return;
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        Where where = this.generateWhere(connection, calculator, objectArray);
        if (Where.validate(where)) {
            if (this.doDelete(calculator)) {
                Delete delete = new Delete(this.table, where, dialect);
                delete.execute(connection);
                return;
            }
            insertOrUpdate = new Update(this.table, where, dialect);
            this.addColumn2InsertOrUpdate(insertOrUpdate, calculator, objectArray, connection);
            if (Update.validate((Update)insertOrUpdate) && ((Update)insertOrUpdate).execute(connection) > 0) {
                return;
            }
        }
        insertOrUpdate = new Insert(this.table, dialect);
        this.addColumn2InsertOrUpdate(insertOrUpdate, calculator, objectArray, connection);
        ((Insert)insertOrUpdate).execute(connection);
        if (map != null) {
            int n2;
            String string = null;
            int n3 = this.getColumnConfigCount();
            for (n2 = 0; n2 < n3; ++n2) {
                ColumnConfig columnConfig = this.getColumnConfig(n2);
                if (!columnConfig.isKey() || !((Insert)insertOrUpdate).isSelfincreaseColumn(columnConfig.getColumnName())) continue;
                string = columnConfig.getColumnName();
                break;
            }
            if (string != null) {
                Object object;
                n2 = 0;
                int n4 = insertOrUpdate.getColumnCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    if (!ComparatorUtils.equals(insertOrUpdate.getColumnName(n3), string)) continue;
                    n2 = insertOrUpdate.getColumnType(n3);
                    break;
                }
                if ((object = this.findRecordInsertedBySelfincreaseKey(string, n2, dialect, connection)) != null) {
                    map.putAll(this.findRecordByKeyAndValue(string, object, connection, dialect));
                }
            }
        }
    }

    private Object findRecordInsertedBySelfincreaseKey(String string, int n, Dialect dialect, Connection connection) {
        Object object = null;
        try {
            String string2 = dialect.getIdentitySelectString(dialect.table2SQL(this.table), string, n);
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            object = resultSet.getObject(1);
            preparedStatement.close();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map findRecordByKeyAndValue(String string, Object object, Connection connection, Dialect dialect) {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        HashMap<String, Object> hashMap;
        block6: {
            hashMap = new HashMap<String, Object>();
            String[] stringArray = DBUtils.checkInColumnNames(connection, DataUtils.createSelectSQL(this.table, null, dialect), 0);
            if (stringArray.length == 0) {
                return hashMap;
            }
            Where where = new Where();
            where.addColumn(string, object);
            Select select = new Select(this.table, where, dialect);
            resultSet = null;
            preparedStatement = null;
            try {
                preparedStatement = select.createPreparedStatement(connection);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(stringArray[i], resultSet.getObject(stringArray[i]));
                }
            }
            catch (SQLException sQLException) {
                try {
                    FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(preparedStatement);
                    throw throwable;
                }
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(preparedStatement);
            }
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(preparedStatement);
        return hashMap;
    }

    private boolean doDelete(Calculator calculator) {
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (!columnConfig.isKey() || !columnConfig.isDeleted(calculator)) continue;
            return true;
        }
        return false;
    }

    private void addColumn2InsertOrUpdate(InsertOrUpdate insertOrUpdate, Calculator calculator, Object[] objectArray, Connection connection) {
        for (int i = 0; i < this.getColumnConfigCount(); ++i) {
            ColumnConfig columnConfig = this.getColumnConfig(i);
            if (columnConfig.isKey() && insertOrUpdate.isUpdate() || columnConfig.isSkipUnmodified() && !columnConfig.isModified(calculator)) continue;
            String string = columnConfig.getColumnName();
            int n = this.getColumnType(string, connection);
            insertOrUpdate.addColumn(string, n, objectArray[i]);
        }
    }

    public String toString() {
        return "update/insert into " + (this.table == null ? "null" : this.table.toString()) + " " + super.toString();
    }
}

