/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.dao;

import com.fr.base.FRContext;
import com.fr.base.ReflectionUtils;
import com.fr.base.StringUtils;
import com.fr.base.dao.JdbcTemplate;
import com.fr.base.dao.ResultSetExtractor;
import com.fr.base.file.DatasourceManager;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.trigger.CalendarITrigger;
import com.fr.schedule.trigger.OnceITrigger;
import com.fr.schedule.trigger.SimpleITrigger;
import com.fr.web.platform.entry.FileEntry;
import com.fr.web.platform.entry.FolderEntry;
import com.fr.web.platform.entry.ReportletEntry;
import com.fr.web.platform.entry.URLEntry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JdbcDaoManager {
    private DatabaseConnection databaseConnection;
    private static Map MAPPING = new HashMap();
    static /* synthetic */ Class class$com$fr$web$platform$entry$FolderEntry;
    static /* synthetic */ Class class$com$fr$web$platform$entry$FileEntry;
    static /* synthetic */ Class class$com$fr$web$platform$entry$ReportletEntry;
    static /* synthetic */ Class class$com$fr$web$platform$entry$URLEntry;
    static /* synthetic */ Class class$com$fr$schedule$task$ScheduleTask;
    static /* synthetic */ Class class$com$fr$schedule$output$ScheduledOutput;
    static /* synthetic */ Class class$com$fr$schedule$output$EmailNotification;
    static /* synthetic */ Class class$com$fr$schedule$trigger$OnceITrigger;
    static /* synthetic */ Class class$com$fr$schedule$trigger$SimpleITrigger;
    static /* synthetic */ Class class$com$fr$schedule$trigger$CalendarITrigger;

    public JdbcDaoManager() {
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        if (StringUtils.isEmpty(datasourceManager.getScheduleDatasource())) {
            FRContext.getLogger().log(Level.WARNING, "Can't found the schedule database!");
            return;
        }
        this.databaseConnection = (DatabaseConnection)datasourceManager.getConnection(datasourceManager.getScheduleDatasource());
    }

    public JdbcDaoManager(JDBCDatabaseConnection jDBCDatabaseConnection) {
        this.databaseConnection = jDBCDatabaseConnection;
    }

    public boolean save(Object object) {
        Class<?> clazz = object.getClass();
        JdbcDaoManager.assertIsInMapping(clazz);
        boolean bl = this.isOracleDatabaseConnection();
        long l = ((Number)new JdbcTemplate(this.databaseConnection).execute(JdbcDaoManager.getObjectMapper(clazz).createInsert(object, bl), true)).longValue();
        return ReflectionUtils.setPrivateFieldValue(object, "id", new Long(l));
    }

    public boolean saveOrUpdate(Object object) {
        long l = ((Number)ReflectionUtils.getPrivateFieldValue(object, "id")).longValue();
        if (l < 0L) {
            return this.save(object);
        }
        return this.update(object);
    }

    public boolean update(Object object) {
        Class<?> clazz = object.getClass();
        JdbcDaoManager.assertIsInMapping(clazz);
        return new JdbcTemplate(this.databaseConnection).execute(JdbcDaoManager.getObjectMapper(clazz).createUpdate(object));
    }

    public Object load(final Class clazz, long l) {
        JdbcDaoManager.assertIsInMapping(clazz);
        final ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(clazz);
        Object object = null;
        try {
            object = new JdbcTemplate(this.databaseConnection).query(objectMapper.createLoadSQL(l), new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws SQLException, Exception {
                    if (resultSet.next()) {
                        return objectMapper.extractResultSet(resultSet, clazz);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return object;
    }

    public List listByFieldValue(final Class clazz, String string, Object object) {
        JdbcDaoManager.assertIsInMapping(clazz);
        final ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(clazz);
        List list = new ArrayList();
        try {
            list = (List)new JdbcTemplate(this.databaseConnection).query(objectMapper.createSQLByFiledValue(string, object), new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws SQLException, Exception {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (resultSet.next()) {
                        arrayList.add(objectMapper.extractResultSet(resultSet, clazz));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return list;
    }

    public List list(final Class clazz) {
        JdbcDaoManager.assertIsInMapping(clazz);
        final ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(clazz);
        List list = new ArrayList();
        try {
            list = (List)new JdbcTemplate(this.databaseConnection).query(objectMapper.createSelectAllSQL(), new ResultSetExtractor(){

                public Object extractData(ResultSet resultSet) throws SQLException, Exception {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (resultSet.next()) {
                        arrayList.add(objectMapper.extractResultSet(resultSet, clazz));
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return list;
    }

    public void deleteById(Class clazz, long l) {
        JdbcDaoManager.assertIsInMapping(clazz);
        ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(clazz);
        try {
            new JdbcTemplate(this.databaseConnection).execute(objectMapper.createDeleteByIdSQL(l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void delete(Class clazz) {
        JdbcDaoManager.assertIsInMapping(clazz);
        ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(clazz);
        try {
            new JdbcTemplate(this.databaseConnection).execute(objectMapper.createDeleteAllSQL());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void delete(Object object) {
        JdbcDaoManager.assertIsInMapping(object.getClass());
        ObjectMapper objectMapper = JdbcDaoManager.getObjectMapper(object.getClass());
        try {
            new JdbcTemplate(this.databaseConnection).execute(objectMapper.deleteByObject(object));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static ObjectMapper getObjectMapper(Class clazz) {
        return (ObjectMapper)MAPPING.get(clazz);
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    private static void assertIsInMapping(Class clazz) {
        if (!MAPPING.containsKey(clazz)) {
            throw new RuntimeException(clazz + " doesn't exists in mapping");
        }
    }

    private boolean isOracleDatabaseConnection() {
        if (this.databaseConnection instanceof JDBCDatabaseConnection) {
            JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)this.databaseConnection;
            String string = jDBCDatabaseConnection.getDriver();
            return string != null && string.endsWith("OracleDriver");
        }
        Connection connection = null;
        try {
            connection = this.databaseConnection.createConnection();
            return DialectFactory.generateDialect(connection) instanceof OracleDialect;
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MAPPING.put(class$com$fr$web$platform$entry$FolderEntry == null ? (class$com$fr$web$platform$entry$FolderEntry = JdbcDaoManager.class$("com.fr.web.platform.entry.FolderEntry")) : class$com$fr$web$platform$entry$FolderEntry, FolderEntry.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$web$platform$entry$FileEntry == null ? (class$com$fr$web$platform$entry$FileEntry = JdbcDaoManager.class$("com.fr.web.platform.entry.FileEntry")) : class$com$fr$web$platform$entry$FileEntry, FileEntry.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$web$platform$entry$ReportletEntry == null ? (class$com$fr$web$platform$entry$ReportletEntry = JdbcDaoManager.class$("com.fr.web.platform.entry.ReportletEntry")) : class$com$fr$web$platform$entry$ReportletEntry, ReportletEntry.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$web$platform$entry$URLEntry == null ? (class$com$fr$web$platform$entry$URLEntry = JdbcDaoManager.class$("com.fr.web.platform.entry.URLEntry")) : class$com$fr$web$platform$entry$URLEntry, URLEntry.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$task$ScheduleTask == null ? (class$com$fr$schedule$task$ScheduleTask = JdbcDaoManager.class$("com.fr.schedule.task.ScheduleTask")) : class$com$fr$schedule$task$ScheduleTask, ScheduleTask.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$output$ScheduledOutput == null ? (class$com$fr$schedule$output$ScheduledOutput = JdbcDaoManager.class$("com.fr.schedule.output.ScheduledOutput")) : class$com$fr$schedule$output$ScheduledOutput, ScheduledOutput.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$output$EmailNotification == null ? (class$com$fr$schedule$output$EmailNotification = JdbcDaoManager.class$("com.fr.schedule.output.EmailNotification")) : class$com$fr$schedule$output$EmailNotification, EmailNotification.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$trigger$OnceITrigger == null ? (class$com$fr$schedule$trigger$OnceITrigger = JdbcDaoManager.class$("com.fr.schedule.trigger.OnceITrigger")) : class$com$fr$schedule$trigger$OnceITrigger, OnceITrigger.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$trigger$SimpleITrigger == null ? (class$com$fr$schedule$trigger$SimpleITrigger = JdbcDaoManager.class$("com.fr.schedule.trigger.SimpleITrigger")) : class$com$fr$schedule$trigger$SimpleITrigger, SimpleITrigger.OBJECT_MAPPER);
        MAPPING.put(class$com$fr$schedule$trigger$CalendarITrigger == null ? (class$com$fr$schedule$trigger$CalendarITrigger = JdbcDaoManager.class$("com.fr.schedule.trigger.CalendarITrigger")) : class$com$fr$schedule$trigger$CalendarITrigger, CalendarITrigger.OBJECT_MAPPER);
    }
}

