/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.dao;

import com.fr.base.ReflectionUtils;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Update;
import com.fr.data.core.db.dml.Where;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.IdFieldMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import java.math.BigDecimal;
import java.sql.ResultSet;

public class ObjectMapper {
    private String tableName;
    private FieldMapper[] fieldMappers;

    public ObjectMapper(String string, FieldMapper[] fieldMapperArray) {
        this.setTableName(string);
        this.setFieldMappers(fieldMapperArray);
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setFieldMappers(FieldMapper[] fieldMapperArray) {
        this.fieldMappers = fieldMapperArray;
    }

    public FieldMapper[] getFieldMappers() {
        return this.fieldMappers;
    }

    public String createSelectAllSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            stringBuffer.append(this.fieldMappers[i].getColumnName());
            if (i == this.fieldMappers.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
        }
        stringBuffer.append("FROM ");
        stringBuffer.append(this.getTableName());
        return stringBuffer.toString();
    }

    public String createDeleteAllSQL() {
        return "DELETE FROM " + this.getTableName();
    }

    public String createDeleteByIdSQL(long l) {
        return this.createDeleteAllSQL() + " WHERE id=" + l;
    }

    public String deleteByObject(Object object) {
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if (!(this.fieldMappers[i] instanceof IdFieldMapper)) continue;
            Object object2 = ReflectionUtils.getPrivateFieldValue(object, this.fieldMappers[i].getFieldName());
            ((IdFieldMapper)this.fieldMappers[i]).delete(object2);
        }
        long l = ((Number)ReflectionUtils.getPrivateFieldValue(object, "id")).longValue();
        return this.createDeleteByIdSQL(l);
    }

    public String createLoadSQL(long l) {
        return this.createSQLByFiledValue("id", new Long(l));
    }

    public String createSQLByFiledValue(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            stringBuffer.append(this.fieldMappers[i].getColumnName());
            if (i == this.fieldMappers.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
        }
        stringBuffer.append("FROM ");
        stringBuffer.append(this.getTableName() + " ");
        String string2 = this.findColumnNameByFieldName(string);
        stringBuffer.append("WHERE " + string2 + "=");
        stringBuffer.append(object.toString());
        return stringBuffer.toString();
    }

    public Insert createInsert(Object object, boolean bl) {
        Insert insert = new Insert(new Table(this.getTableName()));
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            String string = this.fieldMappers[i].getColumnName();
            int n = this.fieldMappers[i].getType();
            Object object2 = ReflectionUtils.getPrivateFieldValue(object, this.fieldMappers[i].getFieldName());
            if ("id".equals(this.fieldMappers[i].getFieldName()) && ObjectMapper.isNegative(object2)) {
                if (!bl) continue;
                insert.putNameExpression("id", OracleDialect.getOracleIncNextValue(this.getTableName()));
                continue;
            }
            if (object2 == null) continue;
            if (this.fieldMappers[i] instanceof IdFieldMapper) {
                object2 = new Long(((IdFieldMapper)this.fieldMappers[i]).field2Id(object2));
            } else if (this.fieldMappers[i] instanceof ValueFieldMapper) {
                object2 = ((ValueFieldMapper)this.fieldMappers[i]).field2Value(object2);
            }
            insert.addColumn(string, n, object2);
        }
        return insert;
    }

    private static boolean isNegative(Object object) {
        if (object instanceof Long) {
            return (Long)object < 0L;
        }
        if (object instanceof Integer) {
            return (Integer)object < 0;
        }
        if (object instanceof String) {
            return Long.valueOf((String)object) < 0L;
        }
        return false;
    }

    public Update createUpdate(Object object) {
        Update update = new Update(new Table(this.getTableName()));
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if ("id".equals(this.fieldMappers[i].getColumnName())) continue;
            Object object2 = ReflectionUtils.getPrivateFieldValue(object, this.fieldMappers[i].getFieldName());
            if (this.fieldMappers[i] instanceof IdFieldMapper) {
                object2 = new Long(((IdFieldMapper)this.fieldMappers[i]).field2Id(object2));
            } else if (this.fieldMappers[i] instanceof ValueFieldMapper) {
                object2 = ((ValueFieldMapper)this.fieldMappers[i]).field2Value(object2);
            }
            update.addColumn(this.fieldMappers[i].getColumnName(), this.fieldMappers[i].getType(), object2);
        }
        Where where = new Where();
        where.addColumn("id", 4, 0, ReflectionUtils.getPrivateFieldValue(object, "id"));
        update.setWhere(where);
        return update;
    }

    public Object extractResultSet(ResultSet resultSet, Class clazz) throws Exception {
        Object t = clazz.newInstance();
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            Object object = null;
            object = this.fieldMappers[i].getType() == 12 ? resultSet.getString(this.fieldMappers[i].getColumnName()) : resultSet.getObject(this.fieldMappers[i].getColumnName());
            if (this.fieldMappers[i] instanceof IdFieldMapper && object != null) {
                object = ((IdFieldMapper)this.fieldMappers[i]).id2Field(((Number)object).longValue());
            } else if (this.fieldMappers[i] instanceof ValueFieldMapper) {
                object = ((ValueFieldMapper)this.fieldMappers[i]).value2Field(object);
            }
            if (object == null) continue;
            if (object instanceof BigDecimal && (this.fieldMappers[i].getType() == -5 || this.fieldMappers[i].getType() == 4)) {
                object = new Long(((BigDecimal)object).longValue());
            }
            ReflectionUtils.setPrivateFieldValue(t, this.fieldMappers[i].getFieldName(), object);
        }
        return t;
    }

    private String findColumnNameByFieldName(String string) {
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if (!string.equals(this.fieldMappers[i].getFieldName())) continue;
            return this.fieldMappers[i].getColumnName();
        }
        return null;
    }
}

