/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.job;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.Calculator;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.ViewScheduleSavedInfo;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.util.Utils;
import com.fr.web.Reportlet;
import com.fr.web.ReportletException;
import com.fr.web.ReportletRequest;
import com.fr.web.core.WebUtils;
import com.fr.web.platform.entry.ReportletEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ViewReportletJob
implements Job {
    static /* synthetic */ Class class$com$fr$schedule$task$ScheduleTask;
    static /* synthetic */ Class class$com$fr$web$platform$entry$ReportletEntry;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Object object;
        Date date = jobExecutionContext.getScheduledFireTime();
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        long l = jobDataMap.getLong("__task__");
        ScheduleTask scheduleTask = (ScheduleTask)ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$task$ScheduleTask == null ? (class$com$fr$schedule$task$ScheduleTask = ViewReportletJob.class$("com.fr.schedule.task.ScheduleTask")) : class$com$fr$schedule$task$ScheduleTask, l);
        FileRepository fileRepository = scheduleTask.getScheduledOutput().getFileRepository();
        File file = fileRepository.getTaskTimeDirFile(scheduleTask.getName(), date);
        if (!file.exists()) {
            Utils.mkdirs(file);
        }
        ScheduledOutput scheduledOutput = scheduleTask.getScheduledOutput();
        long l2 = jobDataMap.getLong("__reportlet__");
        ReportletEntry reportletEntry = (ReportletEntry)ScheduleContext.getJdbcDaoManager().load(class$com$fr$web$platform$entry$ReportletEntry == null ? (class$com$fr$web$platform$entry$ReportletEntry = ViewReportletJob.class$("com.fr.web.platform.entry.ReportletEntry")) : class$com$fr$web$platform$entry$ReportletEntry, l2);
        String string = reportletEntry.getReportletPath();
        if (string == null) {
            FRContext.getLogger().log(Level.WARNING, Inter.getLocText("Report path is Null..."));
            return;
        }
        FRContext.getLogger().log(Level.INFO, "The Task '" + scheduleTask.getName() + "' of " + reportletEntry.getDisplayName() + " starts!");
        String string2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf("."));
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            int n;
            object = WebUtils.initReportletFromPath(string);
            if (object == null) {
                FRContext.getLogger().log(Level.WARNING, "Not found reportlet: " + string);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(date.getTime());
            Calculator calculator = Calculator.createCalculator();
            calculator.set("$date", calendar.getTime());
            TemplateWorkBook templateWorkBook = ((Reportlet)object).createReport(null);
            calculator.setCurrentReport(templateWorkBook.getReport(0));
            calculator.setCurrentTableDataSource(templateWorkBook);
            Object[] objectArray = ScheduleUtils.createCartesianParameterMapList(scheduleTask.getParametersToArray(), calculator);
            List list = (List)objectArray[0];
            calculator.release();
            ViewScheduleSavedInfo viewScheduleSavedInfo = new ViewScheduleSavedInfo();
            List list2 = (List)objectArray[1];
            if (list2.size() > 0) {
                viewScheduleSavedInfo.setFArrayParameters(list2.toArray(new Parameter[list2.size()]));
            }
            String[] stringArray = new String[list2.size()];
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                stringArray[n] = ((Parameter)list2.get(n)).getName();
            }
            for (n = 0; n < list.size(); ++n) {
                Map map = (Map)list.get(n);
                TemplateWorkBook templateWorkBook2 = null;
                try {
                    templateWorkBook2 = ((Reportlet)object).createReport(new ScheduleReportletRequestImpl(map));
                }
                catch (ReportletException reportletException) {
                    FRContext.getLogger().log(Level.WARNING, Inter.getLocText("Not_Found_Reportlet") + ": " + string);
                }
                if (templateWorkBook2 == null) {
                    FRContext.getLogger().log(Level.WARNING, Inter.getLocText("Not_Found_Reportlet") + ": " + string);
                    return;
                }
                ResultWorkBook resultWorkBook = templateWorkBook2.execute(map);
                String string3 = this.createParaString(n, stringArray);
                File[] fileArray = scheduledOutput.exportReportFiles(resultWorkBook, string2 + string3, file);
                for (int i = 0; i < fileArray.length; ++i) {
                    viewScheduleSavedInfo.addMapTemplateFileName(map, fileArray[i].getName());
                    if (fileArray[i].getName().endsWith(".cpt")) continue;
                    arrayList.add(fileArray[i]);
                }
            }
            ViewReportletJob.exportViewScheduleSavedInfo(viewScheduleSavedInfo, file);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
        object = scheduledOutput.getEmailNotification();
        if (object != null) {
            try {
                ((EmailNotification)object).sendEmail(arrayList.toArray(new File[arrayList.size()]));
            }
            catch (EmailException emailException) {
                FRContext.getLogger().log(Level.WARNING, emailException.getMessage(), emailException);
            }
        }
        FRContext.getLogger().log(Level.INFO, "The Task '" + scheduleTask.getName() + "' of " + reportletEntry.getDisplayName() + " has finished!");
    }

    private String createParaString(int n, String[] stringArray) {
        if (stringArray.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_[");
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]).append("_").append(n);
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void exportViewScheduleSavedInfo(ViewScheduleSavedInfo viewScheduleSavedInfo, File file) throws FileNotFoundException {
        BaseXMLUtils.writeXMLFile(new FileOutputStream(new File(file, "info.xml")), viewScheduleSavedInfo);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ScheduleReportletRequestImpl
    implements ReportletRequest {
        private Map map = null;

        public ScheduleReportletRequestImpl(Map map) {
            this.map = map;
        }

        public Object getParameter(String string) {
            return this.map.get(string);
        }
    }
}

