/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.job;

import com.fr.base.FRContext;
import com.fr.report.ReportWriteAttr;
import com.fr.report.ResultReport;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateReport;
import com.fr.report.TemplateWorkBook;
import com.fr.report.script.Calculator;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.web.platform.entry.ReportletEntry;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class WriteReportletJob
implements Job {
    static /* synthetic */ Class class$com$fr$schedule$task$ScheduleTask;
    static /* synthetic */ Class class$com$fr$web$platform$entry$ReportletEntry;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date = jobExecutionContext.getScheduledFireTime();
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        long l = jobDataMap.getLong("__task__");
        ScheduleTask scheduleTask = (ScheduleTask)ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$task$ScheduleTask == null ? (class$com$fr$schedule$task$ScheduleTask = WriteReportletJob.class$("com.fr.schedule.task.ScheduleTask")) : class$com$fr$schedule$task$ScheduleTask, l);
        long l2 = jobDataMap.getLong("__reportlet__");
        ReportletEntry reportletEntry = (ReportletEntry)ScheduleContext.getJdbcDaoManager().load(class$com$fr$web$platform$entry$ReportletEntry == null ? (class$com$fr$web$platform$entry$ReportletEntry = WriteReportletJob.class$("com.fr.web.platform.entry.ReportletEntry")) : class$com$fr$web$platform$entry$ReportletEntry, l2);
        String string = reportletEntry.getReportletPath();
        if (string == null) {
            FRContext.getLogger().log(Level.WARNING, "Reporlet path is null.");
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        Calculator calculator = Calculator.createCalculator();
        calculator.set("$date", calendar.getTime());
        Object[] objectArray = ScheduleUtils.createCartesianParameterMapList(scheduleTask.getParametersToArray(), calculator);
        List list = (List)objectArray[0];
        calculator.release();
        try {
            TemplateWorkBook templateWorkBook = FRContext.getCurrentEnv().readTemplate(string);
            if (templateWorkBook == null) {
                FRContext.getLogger().log(Level.WARNING, "Not found reportlet: " + string);
            }
            for (int i = 0; i < list.size(); ++i) {
                WriteReportletJob.writeReportData(templateWorkBook.execute4Write((Map)list.get(i)), templateWorkBook, Collections.EMPTY_MAP);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
    }

    private static void writeReportData(ResultWorkBook resultWorkBook, TemplateWorkBook templateWorkBook, Map map) throws Exception {
        for (int i = 0; i < templateWorkBook.getReportCount(); ++i) {
            WriteReportletJob.writeInnerReportData(resultWorkBook.getResultReport(i), templateWorkBook.getTemplateReport(i), map);
        }
    }

    private static void writeInnerReportData(ResultReport resultReport, TemplateReport templateReport, Map map) throws Exception {
        ReportWriteAttr reportWriteAttr = templateReport.getReportWriteAttr();
        if (reportWriteAttr == null) {
            return;
        }
        reportWriteAttr.submit(resultReport, templateReport.getTemplateWorkBook(), map);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

