/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.ReportWebAttr;
import com.fr.report.web.EmailManager;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.output.EmailException;
import java.io.File;
import javax.mail.MessagingException;

public class EmailNotification
implements XMLable {
    public static final String XML_TAG = "EmailNotification";
    public static final String TABLE_NAME = "fr_schedule_email";
    private long id = -1L;
    private String toAddress = null;
    private String ccAddress = null;
    private String bccAddress = null;
    private String subject;
    private String bodyContent;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_schedule_email", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("toAddress", 12, "toAddress"), new FieldMapper("ccAddress", 12, "ccAddress"), new FieldMapper("bccAddress", 12, "bccAddress"), new FieldMapper("subject", 12, "subject"), new FieldMapper("bodyContent", 12, "bodyContent")});
    static /* synthetic */ Class class$com$fr$schedule$output$EmailNotification;

    public EmailNotification() {
    }

    public EmailNotification(String string, String string2, String string3, String string4, String string5) {
        this.toAddress = string;
        this.ccAddress = string2;
        this.bccAddress = string3;
        this.subject = string4;
        this.bodyContent = string5;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("toAddress", this.getToAddress());
        jSONObject.put("ccAddress", this.getCcAddress());
        jSONObject.put("bccAddress", this.getBccAddress());
        jSONObject.put("subject", this.getSubject());
        jSONObject.put("bodyContent", this.getBodyContent());
        return jSONObject;
    }

    public static EmailNotification analyzeJSON(JSONObject jSONObject) {
        try {
            EmailNotification emailNotification = null;
            emailNotification = jSONObject.has("id") ? (EmailNotification)ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$output$EmailNotification == null ? (class$com$fr$schedule$output$EmailNotification = EmailNotification.class$("com.fr.schedule.output.EmailNotification")) : class$com$fr$schedule$output$EmailNotification, jSONObject.getLong("id")) : new EmailNotification();
            String string = jSONObject.getString("toAddress");
            String string2 = jSONObject.getString("ccAddress");
            String string3 = jSONObject.getString("bccAddress");
            String string4 = jSONObject.getString("subject");
            String string5 = jSONObject.getString("bodyContent");
            emailNotification.setToAddress(string);
            emailNotification.setCcAddress(string2);
            emailNotification.setBccAddress(string3);
            emailNotification.setSubject(string4);
            emailNotification.setBodyContent(string5);
            return emailNotification;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public void sendEmail(File[] fileArray) throws EmailException {
        if (StringUtils.isNotBlank(this.getToAddress())) {
            try {
                EmailManager emailManager = EmailNotification.getEmailManager();
                if (emailManager == null) {
                    throw new EmailException("Email Manager is not Configed!");
                }
                emailManager.send(this.getToAddress(), this.getCcAddress(), this.getBccAddress(), this.getSubject(), this.getBodyContent(), fileArray);
            }
            catch (MessagingException messagingException) {
                throw new EmailException(messagingException);
            }
        }
    }

    public static EmailManager getEmailManager() {
        EmailManager emailManager = null;
        ReportWebAttr reportWebAttr = FRContext.getConfigManager().getReportWebAttr();
        if (reportWebAttr == null) {
            reportWebAttr = new ReportWebAttr();
            FRContext.getConfigManager().setReportWebAttr(reportWebAttr);
        }
        if ((emailManager = reportWebAttr.getEmailManager()) == null) {
            emailManager = new EmailManager();
            reportWebAttr.setEmailManager(emailManager);
        }
        return emailManager;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setToAddress(String string) {
        this.toAddress = string;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setCcAddress(String string) {
        this.ccAddress = string;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public void setBccAddress(String string) {
        this.bccAddress = string;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setBodyContent(String string) {
        this.bodyContent = string;
    }

    public String getBodyContent() {
        if (this.bodyContent == null) {
            return "";
        }
        return this.bodyContent;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("toAddress");
            if (string != null) {
                this.setToAddress(string);
            }
            if ((string = xMLableReader.getAttr("ccAddress")) != null) {
                this.setCcAddress(string);
            }
            if ((string = xMLableReader.getAttr("bccAddress")) != null) {
                this.setBccAddress(string);
            }
            if ((string = xMLableReader.getAttr("subject")) != null) {
                this.setSubject(string);
            }
            if ((string = xMLableReader.getAttr("bodyContent")) != null) {
                this.setBodyContent(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("toAddress", this.toAddress).attr("ccAddress", this.ccAddress).attr("bccAddress", this.bccAddress).attr("subject", this.subject).attr("bodyContent", this.bodyContent).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmailNotification)) {
            return false;
        }
        EmailNotification emailNotification = (EmailNotification)object;
        return ComparatorUtils.equals(emailNotification.getBccAddress(), this.getBccAddress()) && ComparatorUtils.equals(emailNotification.getCcAddress(), this.getCcAddress()) && ComparatorUtils.equals(emailNotification.getToAddress(), this.getToAddress());
    }

    public Object clone() throws CloneNotSupportedException {
        EmailNotification emailNotification = (EmailNotification)super.clone();
        return emailNotification;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

