/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.FRContext;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import java.io.File;
import java.util.Date;

public class FileRepository
implements XMLable {
    public static final String XML_TAG = "FileRepository";
    private String path = null;

    public FileRepository() {
        if (FRContext.getCurrentEnv() != null) {
            this.setPath(FRContext.getCurrentEnv().getPath() + File.separator + "schedule");
        }
    }

    public FileRepository(String string) {
        this.path = string;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("path", this.getPath());
        return jSONObject;
    }

    public static FileRepository analyzeJSON(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("path");
            return new FileRepository(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public File getTaskDirFile(String string) {
        return new File(this.getPath(), string);
    }

    public File getTaskTimeDirFile(String string, Date date) {
        String string2 = DateUtils.TIMEFORMAT.format(date).replaceAll(":", "");
        return new File(this.getTaskDirFile(string + File.separator + DateUtils.DATEFORMAT2.format(date)), string2.substring(0, string2.length() - 2));
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttr("path")) != null) {
            this.setPath(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("path", this.path).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileRepository)) {
            return false;
        }
        FileRepository fileRepository = (FileRepository)object;
        return ComparatorUtils.equals(fileRepository.getPath(), this.getPath());
    }

    public Object clone() throws CloneNotSupportedException {
        FileRepository fileRepository = (FileRepository)super.clone();
        return fileRepository;
    }
}

