/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.XMLable;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;

public class OutputFileFormat
implements XMLable {
    public static final String XML_TAG = "OutputFileFormat";
    private static final int CONVERT_TO_CPT = 1;
    private static final int CONVERT_TO_EXCEL = 2;
    private static final int CONVERT_TO_PDF = 4;
    private static final int CONVERT_TO_WORD = 8;
    private int format = 1;

    public OutputFileFormat() {
    }

    public OutputFileFormat(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setConvertToCpt(bl);
        this.setConvertToExcel(bl2);
        this.setConvertToPdf(bl3);
        this.setConvertToWord(bl4);
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isConvertToCpt", this.isConvertToCpt());
        jSONObject.put("isConvertToExcel", this.isConvertToExcel());
        jSONObject.put("isConvertToPdf", this.isConvertToPdf());
        jSONObject.put("isConvertToWord", this.isConvertToWord());
        return jSONObject;
    }

    public static OutputFileFormat analyzeJSON(JSONObject jSONObject) {
        try {
            boolean bl = jSONObject.getBoolean("isConvertToCpt");
            boolean bl2 = jSONObject.getBoolean("isConvertToExcel");
            boolean bl3 = jSONObject.getBoolean("isConvertToPdf");
            boolean bl4 = jSONObject.getBoolean("isConvertToWord");
            return new OutputFileFormat(bl, bl2, bl3, bl4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getFormat() {
        return this.format;
    }

    public boolean isConvertToCpt() {
        return (this.getFormat() & 1) != 0;
    }

    public void setConvertToCpt(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 1);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFE);
        }
    }

    public boolean isConvertToExcel() {
        return (this.getFormat() & 2) != 0;
    }

    public void setConvertToExcel(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 2);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFD);
        }
    }

    public boolean isConvertToPdf() {
        return (this.getFormat() & 4) != 0;
    }

    public void setConvertToPdf(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 4);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFFB);
        }
    }

    public boolean isConvertToWord() {
        return (this.getFormat() & 8) != 0;
    }

    public void setConvertToWord(boolean bl) {
        if (bl) {
            this.setFormat(this.getFormat() | 8);
        } else {
            this.setFormat(this.getFormat() & 0xFFFFFFF7);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr() && (string = xMLableReader.getAttr("format")) != null) {
            this.setFormat(Byte.parseByte(string));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("format", this.getFormat()).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OutputFileFormat)) {
            return false;
        }
        OutputFileFormat outputFileFormat = (OutputFileFormat)object;
        return outputFileFormat.getFormat() == this.getFormat();
    }

    public Object clone() throws CloneNotSupportedException {
        OutputFileFormat outputFileFormat = (OutputFileFormat)super.clone();
        return outputFileFormat;
    }
}

