/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.base.ReflectionUtils;
import com.fr.base.XMLable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.report.ResultWorkBook;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.PDFExporter;
import com.fr.report.io.TemplateExporter;
import com.fr.report.io.WordExporter;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.IdFieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.OutputFileFormat;
import com.fr.schedule.util.ScheduleConstants;
import com.fr.web.platform.entry.FileEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;

public class ScheduledOutput
implements XMLable {
    public static final String XML_TAG = "ScheduleOutput";
    public static final String TABLE_NAME = "fr_schedule_output";
    private long id = -1L;
    private String baseFileName;
    private String description;
    private long folderEntryId = -1L;
    private OutputFileFormat outputFileFormat;
    private EmailNotification emailNotification;
    private FileRepository fileRepository = new FileRepository();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_schedule_output", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("baseFileName", 12, "base_name"), new FieldMapper("description", 12, "description"), new FieldMapper("folderEntryId", 4, "folderEntryId"), new ValueFieldMapper("outputFileFormat", 4, "format"){

        public Object value2Field(Object object) {
            if (object == null) {
                return new OutputFileFormat();
            }
            OutputFileFormat outputFileFormat = new OutputFileFormat();
            outputFileFormat.setFormat(((Number)object).intValue());
            return outputFileFormat;
        }

        public Object field2Value(Object object) {
            if (object == null) {
                return new Integer(new OutputFileFormat().getFormat());
            }
            return ReflectionUtils.getPrivateFieldValue(object, "format");
        }
    }, new IdFieldMapper(class$com$fr$schedule$output$EmailNotification == null ? (class$com$fr$schedule$output$EmailNotification = ScheduledOutput.class$("com.fr.schedule.output.EmailNotification")) : class$com$fr$schedule$output$EmailNotification, "emailNotification", -5, "emailId")});
    static /* synthetic */ Class class$com$fr$schedule$output$ScheduledOutput;
    static /* synthetic */ Class class$com$fr$schedule$output$EmailNotification;

    public ScheduledOutput() {
    }

    public ScheduledOutput(String string, String string2, FileRepository fileRepository, OutputFileFormat outputFileFormat, EmailNotification emailNotification) {
        this.baseFileName = string;
        this.description = string2;
        this.fileRepository = fileRepository;
        this.outputFileFormat = outputFileFormat;
        this.emailNotification = emailNotification;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("baseFileName", this.getBaseFileName());
        jSONObject.put("description", this.getDescription());
        if (this.getFolderEntryId() > -1L) {
            jSONObject.put("folderEntryId", "0" + this.getFolderEntryId());
        }
        JSONObject jSONObject2 = this.getOutputFileFormat().createJSONConfig();
        jSONObject.put("outputFileFormat", jSONObject2);
        if (this.getEmailNotification() != null) {
            JSONObject jSONObject3 = this.getEmailNotification().createJSONConfig();
            jSONObject.put("emailNotification", jSONObject3);
        }
        return jSONObject;
    }

    public static ScheduledOutput analyzeJSON(JSONObject jSONObject) {
        try {
            ScheduledOutput scheduledOutput = null;
            if (jSONObject.length() == 0) {
                return new ScheduledOutput();
            }
            scheduledOutput = jSONObject.has("id") ? (ScheduledOutput)ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$output$ScheduledOutput == null ? (class$com$fr$schedule$output$ScheduledOutput = ScheduledOutput.class$("com.fr.schedule.output.ScheduledOutput")) : class$com$fr$schedule$output$ScheduledOutput, jSONObject.getLong("id")) : new ScheduledOutput();
            String string = jSONObject.getString("baseFileName");
            String string2 = jSONObject.getString("description");
            long l = -1L;
            if (jSONObject.has("folderEntryId")) {
                l = jSONObject.getLong("folderEntryId");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("outputFileFormat");
            OutputFileFormat outputFileFormat = OutputFileFormat.analyzeJSON(jSONObject2);
            EmailNotification emailNotification = null;
            if (jSONObject.has("emailNotification")) {
                JSONObject jSONObject3 = jSONObject.getJSONObject("emailNotification");
                emailNotification = EmailNotification.analyzeJSON(jSONObject3);
            }
            scheduledOutput.setBaseFileName(string);
            scheduledOutput.setDescription(string2);
            scheduledOutput.setFolderEntryId(l);
            scheduledOutput.setOutputFileFormat(outputFileFormat);
            scheduledOutput.setEmailNotification(emailNotification);
            return scheduledOutput;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public File[] exportReportFiles(ResultWorkBook resultWorkBook, String string, File file) throws Exception {
        FileEntry fileEntry;
        FileOutputStream fileOutputStream;
        File file2;
        if (this.outputFileFormat == null) {
            return new File[0];
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.outputFileFormat.isConvertToCpt()) {
            file2 = ScheduledOutput.generateUnExsitFile(file, string, ".cpt");
            fileOutputStream = new FileOutputStream(file2);
            new TemplateExporter().export((OutputStream)fileOutputStream, resultWorkBook);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            arrayList.add(file2);
            if (this.folderEntryId > -1L) {
                fileEntry = new FileEntry(this.baseFileName + ".cpt", this.description, file2.getAbsolutePath());
                fileEntry.setParentId(this.folderEntryId);
                ScheduleContext.getJdbcDaoManager().saveOrUpdate(fileEntry);
            }
        }
        if (this.outputFileFormat.isConvertToExcel()) {
            file2 = ScheduledOutput.generateUnExsitFile(file, string, ".xls");
            fileOutputStream = new FileOutputStream(file2);
            new ExcelExporter(null).export((OutputStream)fileOutputStream, resultWorkBook);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            arrayList.add(file2);
            if (this.folderEntryId > -1L) {
                fileEntry = new FileEntry(this.baseFileName + ".xls", this.description, file2.getAbsolutePath());
                fileEntry.setParentId(this.folderEntryId);
                ScheduleContext.getJdbcDaoManager().saveOrUpdate(fileEntry);
            }
        }
        if (this.outputFileFormat.isConvertToPdf()) {
            file2 = ScheduledOutput.generateUnExsitFile(file, string, ".pdf");
            fileOutputStream = new FileOutputStream(file2);
            new PDFExporter().export((OutputStream)fileOutputStream, resultWorkBook);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            arrayList.add(file2);
            if (this.folderEntryId > -1L) {
                fileEntry = new FileEntry(this.baseFileName + ".pdf", this.description, file2.getAbsolutePath());
                fileEntry.setParentId(this.folderEntryId);
                ScheduleContext.getJdbcDaoManager().saveOrUpdate(fileEntry);
            }
        }
        if (this.outputFileFormat.isConvertToWord()) {
            file2 = ScheduledOutput.generateUnExsitFile(file, string, ".doc");
            fileOutputStream = new FileOutputStream(file2);
            new WordExporter().export((OutputStream)fileOutputStream, resultWorkBook);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            arrayList.add(file2);
            if (this.folderEntryId > -1L) {
                fileEntry = new FileEntry(this.baseFileName + ".doc", this.description, file2.getAbsolutePath());
                fileEntry.setParentId(this.folderEntryId);
                ScheduleContext.getJdbcDaoManager().saveOrUpdate(fileEntry);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void setBaseFileName(String string) {
        this.baseFileName = string;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFolderEntryId(long l) {
        this.folderEntryId = l;
    }

    public long getFolderEntryId() {
        return this.folderEntryId;
    }

    public void setFileRepository(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public FileRepository getFileRepository() {
        return this.fileRepository;
    }

    public void setOutputFileFormat(OutputFileFormat outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public OutputFileFormat getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setEmailNotification(EmailNotification emailNotification) {
        if (this.id != 0L && this.emailNotification != null && (emailNotification == null || this.emailNotification.getId() != emailNotification.getId())) {
            ScheduleContext.getJdbcDaoManager().deleteById(class$com$fr$schedule$output$EmailNotification == null ? (class$com$fr$schedule$output$EmailNotification = ScheduledOutput.class$("com.fr.schedule.output.EmailNotification")) : class$com$fr$schedule$output$EmailNotification, this.emailNotification.getId());
        }
        this.emailNotification = emailNotification;
    }

    public EmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    private static File generateUnExsitFile(File file, String string, String string2) {
        File file2 = new File(file, string + "_" + DateUtils.getDate2AllIncludeSSS(new Date()) + "_" + ScheduleConstants.RANDOM.nextInt(1000) + string2);
        while (file2.exists()) {
            file2 = new File(file, string + "_" + DateUtils.getDate2AllIncludeSSS(new Date()) + "_" + ScheduleConstants.RANDOM.nextInt(1000) + string2);
        }
        return file2;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttr("baseFileName");
            if (string != null) {
                this.setBaseFileName(string);
            }
            if ((string = xMLableReader.getAttr("description")) != null) {
                this.setDescription(string);
            }
        } else if (xMLableReader.isChildNode()) {
            if ("FileRepository".equals(xMLableReader.getTagName())) {
                this.fileRepository = (FileRepository)xMLableReader.readXMLObject(new FileRepository());
            } else if ("OutputFileFormat".equals(xMLableReader.getTagName())) {
                this.outputFileFormat = (OutputFileFormat)xMLableReader.readXMLObject(new OutputFileFormat());
            } else if ("EmailNotification".equals(xMLableReader.getTagName())) {
                this.emailNotification = (EmailNotification)xMLableReader.readXMLObject(new EmailNotification());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("baseFileName", this.baseFileName).attr("description", this.description);
        if (this.fileRepository != null) {
            this.fileRepository.writeXML(xMLPrintWriter);
        }
        if (this.outputFileFormat != null) {
            this.outputFileFormat.writeXML(xMLPrintWriter);
        }
        if (this.emailNotification != null) {
            this.emailNotification.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduledOutput)) {
            return false;
        }
        ScheduledOutput scheduledOutput = (ScheduledOutput)object;
        return ComparatorUtils.equals(this.baseFileName, scheduledOutput.baseFileName) && ComparatorUtils.equals(this.description, scheduledOutput.description) && ComparatorUtils.equals(this.fileRepository, scheduledOutput.fileRepository) && ComparatorUtils.equals(this.outputFileFormat, scheduledOutput.outputFileFormat) && ComparatorUtils.equals(this.emailNotification, scheduledOutput.emailNotification);
    }

    public Object clone() throws CloneNotSupportedException {
        ScheduledOutput scheduledOutput = (ScheduledOutput)super.clone();
        if (this.fileRepository != null) {
            scheduledOutput.setFileRepository((FileRepository)this.fileRepository.clone());
        }
        if (this.outputFileFormat != null) {
            scheduledOutput.setOutputFileFormat((OutputFileFormat)this.outputFileFormat.clone());
        }
        if (this.emailNotification != null) {
            scheduledOutput.setEmailNotification((EmailNotification)this.emailNotification.clone());
        }
        return scheduledOutput;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

