/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.task;

import com.fr.base.ReflectionUtils;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.report.parameter.Parameter;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.IdFieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.trigger.ITrigger;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import com.fr.web.platform.TransmitParameters;
import com.fr.web.platform.entry.BaseEntry;
import com.fr.web.platform.entry.ReportletEntry;

public class ScheduleTask {
    public static final String TABLE_NAME = "fr_schedule_task";
    private long id = -1L;
    private long groupId;
    private String name;
    private String description;
    private ITrigger iTrigger;
    private TransmitParameters taskParameters;
    private ScheduledOutput scheduledOutput;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_schedule_task", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("groupId", 4, "groupId"), new FieldMapper("name", 12, "name"), new FieldMapper("description", 12, "description"), new IdFieldMapper(class$com$fr$schedule$trigger$ITrigger == null ? (class$com$fr$schedule$trigger$ITrigger = ScheduleTask.class$("com.fr.schedule.trigger.ITrigger")) : class$com$fr$schedule$trigger$ITrigger, "iTrigger", 4, "itriggerId"){

        public Object id2Field(long l) {
            String string = String.valueOf(l);
            if (string.startsWith("1")) {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$trigger$OnceITrigger == null ? (class$com$fr$schedule$trigger$OnceITrigger = ScheduleTask.class$("com.fr.schedule.trigger.OnceITrigger")) : class$com$fr$schedule$trigger$OnceITrigger, l);
            }
            if (string.startsWith("2")) {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$trigger$SimpleITrigger == null ? (class$com$fr$schedule$trigger$SimpleITrigger = ScheduleTask.class$("com.fr.schedule.trigger.SimpleITrigger")) : class$com$fr$schedule$trigger$SimpleITrigger, l);
            }
            if (string.startsWith("3")) {
                l = Long.parseLong(string.substring(1));
                return ScheduleContext.getJdbcDaoManager().load(class$com$fr$schedule$trigger$CalendarITrigger == null ? (class$com$fr$schedule$trigger$CalendarITrigger = ScheduleTask.class$("com.fr.schedule.trigger.CalendarITrigger")) : class$com$fr$schedule$trigger$CalendarITrigger, l);
            }
            return null;
        }

        public long field2Id(Object object) {
            if (object == null) {
                return -1L;
            }
            ScheduleContext.getJdbcDaoManager().saveOrUpdate(object);
            long l = ((Number)ReflectionUtils.getPrivateFieldValue(object, "id")).longValue();
            String string = ((ITrigger)object).getITriggerIdPrefix() + String.valueOf(l);
            return Long.parseLong(string);
        }
    }, new ValueFieldMapper("taskParameters", 12, "task_parameters"){

        public Object value2Field(Object object) {
            String string = (String)object;
            if (StringUtils.isBlank(string)) {
                return null;
            }
            TransmitParameters transmitParameters = null;
            try {
                transmitParameters = TransmitParameters.parseJSON(new JSONArray(string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return transmitParameters;
        }

        public Object field2Value(Object object) {
            if (object == null) {
                return "";
            }
            TransmitParameters transmitParameters = (TransmitParameters)object;
            String string = "";
            try {
                string = transmitParameters.createJSON().toString();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return string;
        }
    }, new IdFieldMapper(class$com$fr$schedule$output$ScheduledOutput == null ? (class$com$fr$schedule$output$ScheduledOutput = ScheduleTask.class$("com.fr.schedule.output.ScheduledOutput")) : class$com$fr$schedule$output$ScheduledOutput, "scheduledOutput", 4, "scheduledOupputId")});
    static /* synthetic */ Class class$com$fr$web$platform$entry$ReportletEntry;
    static /* synthetic */ Class class$com$fr$schedule$output$ScheduledOutput;
    static /* synthetic */ Class class$com$fr$schedule$trigger$ITrigger;
    static /* synthetic */ Class class$com$fr$schedule$trigger$OnceITrigger;
    static /* synthetic */ Class class$com$fr$schedule$trigger$SimpleITrigger;
    static /* synthetic */ Class class$com$fr$schedule$trigger$CalendarITrigger;

    public ScheduleTask() {
    }

    public ScheduleTask(String string) {
        this.name = string;
    }

    public ScheduleTask(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public ScheduleTask(long l, String string, String string2, ITrigger iTrigger, TransmitParameters transmitParameters, ScheduledOutput scheduledOutput) {
        this.groupId = l;
        this.name = string;
        this.description = string2;
        this.iTrigger = iTrigger;
        this.taskParameters = transmitParameters;
        this.scheduledOutput = scheduledOutput;
    }

    public JSONObject createJSONConfig() throws JSONException {
        Object object;
        Object object2;
        JSONObject jSONObject = new JSONObject();
        if (this.getITrigger().getStartTime() != null && this.getITrigger().getStartTime().getTime() > System.currentTimeMillis()) {
            jSONObject.put("state", -2);
        } else {
            try {
                object2 = ScheduleContext.getScheduler();
                object = (ReportletEntry)ScheduleContext.getJdbcDaoManager().load(class$com$fr$web$platform$entry$ReportletEntry == null ? (class$com$fr$web$platform$entry$ReportletEntry = ScheduleTask.class$("com.fr.web.platform.entry.ReportletEntry")) : class$com$fr$web$platform$entry$ReportletEntry, this.getGroupId());
                Trigger[] triggerArray = object2.getTriggersOfJob(this.getName(), ((BaseEntry)object).getDisplayName());
                if (triggerArray.length > 0) {
                    Trigger trigger = triggerArray[0];
                    int n = object2.getTriggerState(trigger.getName(), trigger.getGroup());
                    jSONObject.put("state", n);
                }
            }
            catch (SchedulerException schedulerException) {
                schedulerException.printStackTrace();
            }
        }
        jSONObject.put("id", this.getId());
        jSONObject.put("groupId", this.getGroupId());
        jSONObject.put("name", this.getName());
        jSONObject.put("description", this.getDescription());
        if (this.getITrigger() != null) {
            object2 = this.getITrigger().createJSONConfig();
            jSONObject.put("iTrigger", object2);
        }
        object2 = this.getTaskParameters().createJSON();
        jSONObject.put("taskParameters", object2);
        if (this.getScheduledOutput() != null) {
            object = this.getScheduledOutput().createJSONConfig();
            jSONObject.put("scheduledOutput", object);
        }
        return jSONObject;
    }

    public boolean appendToReportletEntry(ReportletEntry reportletEntry) {
        this.setGroupId(reportletEntry.getId());
        return ScheduleContext.getJdbcDaoManager().saveOrUpdate(this);
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setGroupId(long l) {
        this.groupId = l;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setITrigger(ITrigger iTrigger) {
        this.iTrigger = iTrigger;
    }

    public ITrigger getITrigger() {
        return this.iTrigger;
    }

    public void setTaskParameters(TransmitParameters transmitParameters) {
        this.taskParameters = transmitParameters;
    }

    public TransmitParameters getTaskParameters() {
        return this.taskParameters;
    }

    public void setScheduledOutput(ScheduledOutput scheduledOutput) {
        if (this.id != 0L && this.scheduledOutput != null && (scheduledOutput == null || scheduledOutput.getId() != this.scheduledOutput.getId())) {
            ScheduleContext.getJdbcDaoManager().deleteById(class$com$fr$schedule$output$ScheduledOutput == null ? (class$com$fr$schedule$output$ScheduledOutput = ScheduleTask.class$("com.fr.schedule.output.ScheduledOutput")) : class$com$fr$schedule$output$ScheduledOutput, this.scheduledOutput.getId());
        }
        this.scheduledOutput = scheduledOutput;
    }

    public ScheduledOutput getScheduledOutput() {
        return this.scheduledOutput;
    }

    public Parameter[] getParametersToArray() {
        return this.getTaskParameters() == null ? new Parameter[]{} : this.getTaskParameters().toArray();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScheduleTask)) {
            return false;
        }
        ScheduleTask scheduleTask = (ScheduleTask)object;
        return this.id == scheduleTask.id && this.groupId == scheduleTask.groupId && ComparatorUtils.equals(this.name, scheduleTask.name) && ComparatorUtils.equals(this.description, scheduleTask.description) && ComparatorUtils.equals(this.iTrigger, scheduleTask.iTrigger) && ComparatorUtils.equals(scheduleTask.getTaskParameters(), this.getTaskParameters()) && ComparatorUtils.equals(this.scheduledOutput, scheduleTask.scheduledOutput);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

