/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.task;

import com.fr.base.FCloneable;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.report.cellElement.Formula;
import com.fr.report.parameter.Parameter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TaskParameters
implements FCloneable {
    public static final String STRING = "String";
    public static final String INTEGER = "Integer";
    public static final String DOUBLE = "Double";
    public static final String DATE = "Date";
    public static final String BOOLEAN = "Boolean";
    public static final String FORMULA = "Formula";
    private List parameterList = new ArrayList();

    public TaskParameters() {
    }

    public TaskParameters(Parameter[] parameterArray) {
        for (int i = 0; i < parameterArray.length; ++i) {
            this.add(parameterArray[i]);
        }
    }

    public JSONArray createJSON() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.count(); ++i) {
            String string;
            JSONObject jSONObject = new JSONObject();
            Parameter parameter = this.get(i);
            jSONObject.put("name", parameter.getName());
            if (parameter.getValue() instanceof Date) {
                string = DateUtils.DATEFORMAT2.format(parameter.getValue());
                jSONObject.put("value", string);
            } else {
                jSONObject.put("value", parameter.getValue());
            }
            string = parameter.getValue().getClass().getName();
            int n = string.lastIndexOf(46) + 1;
            if (n > 0) {
                string = string.substring(n);
            }
            jSONObject.put("type", string);
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public static TaskParameters parseJSON(JSONArray jSONArray) throws JSONException {
        TaskParameters taskParameters = new TaskParameters();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            Parameter parameter = new Parameter();
            parameter.setName(jSONObject.getString("name"));
            String string = jSONObject.getString("type");
            if (STRING.equals(string)) {
                parameter.setValue(jSONObject.getString("value"));
            } else if (INTEGER.equals(string)) {
                parameter.setValue(Integer.valueOf(jSONObject.getString("value")));
            } else if (DOUBLE.equals(string)) {
                parameter.setValue(Double.valueOf(jSONObject.getString("value")));
            } else if (DATE.equals(string)) {
                String string2 = jSONObject.getString("value");
                try {
                    parameter.setValue(DateUtils.DATEFORMAT2.parse(string2));
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            } else if (BOOLEAN.equals(string)) {
                parameter.setValue(jSONObject.getBoolean("value"));
            } else if (FORMULA.equals(string)) {
                parameter.setValue(new Formula(jSONObject.getString("value")));
            }
            taskParameters.add(parameter);
        }
        return taskParameters;
    }

    public int count() {
        return this.parameterList.size();
    }

    public Parameter[] toArray() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    public Parameter get(int n) {
        return (Parameter)this.parameterList.get(n);
    }

    public void add(Parameter parameter) {
        this.parameterList.add(parameter);
    }

    public void set(int n, Parameter parameter) {
        this.parameterList.set(n, parameter);
    }

    public void clear() {
        this.parameterList.clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TaskParameters)) {
            return false;
        }
        TaskParameters taskParameters = (TaskParameters)object;
        return ComparatorUtils.equals(this.parameterList, taskParameters.parameterList);
    }

    public Object clone() throws CloneNotSupportedException {
        TaskParameters taskParameters = (TaskParameters)super.clone();
        if (this.parameterList != null) {
            taskParameters.parameterList = new ArrayList();
            for (int i = 0; i < this.parameterList.size(); ++i) {
                Object object = this.parameterList.get(i);
                if (object instanceof FCloneable) {
                    object = ((FCloneable)object).clone();
                }
                taskParameters.parameterList.add(object);
            }
        }
        return taskParameters;
    }
}

