/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.trigger;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.trigger.ITrigger;
import com.fr.third.org.quartz.CronTrigger;
import com.fr.third.org.quartz.Trigger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import oracle.sql.TIMESTAMP;

public class CalendarITrigger
implements ITrigger {
    public static final String TABLE_NAME = "fr_calendar_itrigger";
    public static final int IMMEDIATE = 1;
    public static final int ON = 2;
    public static final int EVERY_DAY = 1;
    public static final int WEEK_DAYS = 2;
    public static final int MONTH_DAYS = 3;
    public static final String ALL = "*";
    private long id = -1L;
    private long version;
    private String timeZoneID = TimeZone.getDefault().getID();
    private long startType = 1L;
    private Date startTime = null;
    private Date endTime = null;
    private long minutes = 0L;
    private long hours = 0L;
    private long dayType = 1L;
    private String weekDays = "*";
    private String monthDays = "*";
    private String months = "*";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_calendar_itrigger", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("timeZoneID", 12, "timezone_id"), new FieldMapper("startType", 4, "start_type"), new ValueFieldMapper("startTime", 93, "startTime"){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return object;
        }
    }, new ValueFieldMapper("endTime", 93, "endTime"){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return object;
        }
    }, new FieldMapper("minutes", 4, "minutes"), new FieldMapper("hours", 4, "hours"), new FieldMapper("dayType", 4, "day_type"), new FieldMapper("weekDays", 12, "week_days"), new FieldMapper("monthDays", 12, "month_days"), new FieldMapper("months", 12, "months")});

    public static CalendarITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            Date date;
            String string;
            CalendarITrigger calendarITrigger = new CalendarITrigger();
            long l = jSONObject.getLong("startType");
            calendarITrigger.setStartType(l);
            if (l == 2L) {
                string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    calendarITrigger.setStartTime(date);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            if (StringUtils.isNotBlank(string = jSONObject.getString("endTime"))) {
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    calendarITrigger.setEndTime(date);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            long l2 = jSONObject.getLong("dayType");
            calendarITrigger.setDayType(l2);
            long l3 = jSONObject.getLong("minutes");
            calendarITrigger.setMinutes(l3);
            long l4 = jSONObject.getLong("hours");
            calendarITrigger.setHours(l4);
            String string2 = jSONObject.getString("months");
            calendarITrigger.setMonths(string2);
            if (l2 == 2L) {
                String string3 = jSONObject.getString("weekDays");
                calendarITrigger.setWeekDays(string3);
            } else if (l2 == 3L) {
                String string4 = jSONObject.getString("monthDays");
                calendarITrigger.setMonthDays(string4);
            }
            if (jSONObject.has("id")) {
                calendarITrigger.setId(jSONObject.getLong("id"));
            }
            return calendarITrigger;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public JSONObject createJSONConfig() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            Date date;
            jSONObject.put("id", this.getId());
            jSONObject.put("timeZoneID", this.getTimeZoneID());
            jSONObject.put("startType", this.getStartType());
            if (2L == this.getStartType()) {
                date = this.getStartTime();
                string = DateUtils.DATETIMEFORMAT2.format(date);
                jSONObject.put("startTime", string);
            }
            jSONObject.put("recurrenceType", "calendar");
            if (this.getEndTime() != null) {
                date = this.getEndTime();
                string = DateUtils.DATETIMEFORMAT2.format(date);
                jSONObject.put("endTime", string);
            }
            long l = this.getMinutes();
            jSONObject.put("minutes", l);
            long l2 = this.getHours();
            jSONObject.put("hours", l2);
            long l3 = this.getDayType();
            jSONObject.put("dayType", l3);
            if (l3 == 2L) {
                jSONObject.put("weekDays", this.getWeekDays());
            } else if (l3 == 3L) {
                jSONObject.put("monthDays", this.getMonthDays());
            }
            jSONObject.put("months", this.getMonths());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public Trigger createTrigger() {
        CronTrigger cronTrigger = new CronTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                cronTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("The statemenet is illegal.");
            }
        }
        if (this.getEndTime() != null) {
            cronTrigger.setEndTime(this.getEndTime());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0').append(' ');
        stringBuffer.append(this.getMinutes()).append(' ');
        stringBuffer.append(this.getHours()).append(' ');
        if (this.getDayType() == 1L) {
            stringBuffer.append('*').append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append('?');
        } else if (this.getDayType() == 2L) {
            stringBuffer.append('?').append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append(this.getWeekDays());
        } else if (this.getDayType() == 3L) {
            stringBuffer.append(this.getMonthDays()).append(' ');
            stringBuffer.append(this.getMonths()).append(' ');
            stringBuffer.append('?');
        }
        try {
            cronTrigger.setCronExpression(stringBuffer.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        cronTrigger.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        return cronTrigger;
    }

    public int getITriggerIdPrefix() {
        return 3;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public long getVersion() {
        return this.version;
    }

    public void setTimeZoneID(String string) {
        this.timeZoneID = string;
    }

    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    public void setStartType(long l) {
        this.startType = l;
    }

    public long getStartType() {
        return this.startType;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setMinutes(long l) {
        this.minutes = l;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public void setHours(long l) {
        this.hours = l;
    }

    public long getHours() {
        return this.hours;
    }

    public void setDayType(long l) {
        this.dayType = l;
    }

    public long getDayType() {
        return this.dayType;
    }

    public void setWeekDays(String string) {
        this.weekDays = string;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setMonthDays(String string) {
        this.monthDays = string;
    }

    public String getMonthDays() {
        return this.monthDays;
    }

    public void setMonths(String string) {
        this.months = string;
    }

    public String getMonths() {
        return this.months;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof CalendarITrigger)) {
            return false;
        }
        CalendarITrigger calendarITrigger = (CalendarITrigger)object;
        return this.getId() == calendarITrigger.getId() && this.getVersion() == calendarITrigger.getVersion() && this.getStartType() == calendarITrigger.getStartType() && ComparatorUtils.equals(this.getStartTime(), calendarITrigger.getStartTime()) && ComparatorUtils.equals(this.getEndTime(), calendarITrigger.getEndTime()) && this.getMinutes() == calendarITrigger.getMinutes() && this.getHours() == calendarITrigger.getHours() && this.getDayType() == calendarITrigger.getDayType() && ComparatorUtils.equals(this.getWeekDays(), calendarITrigger.getWeekDays()) && ComparatorUtils.equals(this.getMonthDays(), calendarITrigger.getMonthDays()) && ComparatorUtils.equals(this.getMonths(), calendarITrigger.getMonths());
    }

    public Object clone() throws CloneNotSupportedException {
        CalendarITrigger calendarITrigger = (CalendarITrigger)super.clone();
        return calendarITrigger;
    }
}

