/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.trigger;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.trigger.ITrigger;
import com.fr.third.org.quartz.SimpleTrigger;
import com.fr.third.org.quartz.Trigger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import oracle.sql.TIMESTAMP;

public class OnceITrigger
implements ITrigger {
    public static final String TABLE_NAME = "fr_once_itrigger";
    public static final int IMMEDIATE = 1;
    public static final int ON = 2;
    private long id = -1L;
    private long version;
    private String timeZoneID = TimeZone.getDefault().getID();
    private long startType = 1L;
    private Date startTime;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_once_itrigger", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("timeZoneID", 12, "timezone_id"), new FieldMapper("startType", 4, "start_type"), new ValueFieldMapper("startTime", 93, "startTime"){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return object;
        }
    }});

    public OnceITrigger() {
    }

    public OnceITrigger(int n, Date date) {
        this.startType = n;
        if (date != null) {
            this.startTime = date;
        }
    }

    public static OnceITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            OnceITrigger onceITrigger = null;
            long l = jSONObject.getLong("startType");
            Date date = null;
            if (l == 2L) {
                String string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            onceITrigger = new OnceITrigger((int)l, date);
            if (jSONObject.has("id")) {
                onceITrigger.setId(jSONObject.getLong("id"));
            }
            return onceITrigger;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public JSONObject createJSONConfig() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", this.getId());
            jSONObject.put("timeZoneID", this.getTimeZoneID());
            jSONObject.put("startType", this.getStartType());
            if (this.getStartTime() != null) {
                Date date = this.getStartTime();
                String string = DateUtils.DATETIMEFORMAT2.format(date);
                jSONObject.put("startTime", string);
                jSONObject.put("recurrenceType", "once");
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public Trigger createTrigger() {
        if (this.getStartType() == 1L) {
            return new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        }
        if (this.getStartType() == 2L && this.getStartTime() != null) {
            return new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs", this.getStartTime());
        }
        throw new IllegalStateException("The statemenet is illegal.");
    }

    public int getITriggerIdPrefix() {
        return 1;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public long getVersion() {
        return this.version;
    }

    public void setTimeZoneID(String string) {
        this.timeZoneID = string;
    }

    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    public void setStartType(long l) {
        this.startType = l;
    }

    public long getStartType() {
        return this.startType;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof OnceITrigger)) {
            return false;
        }
        OnceITrigger onceITrigger = (OnceITrigger)object;
        return onceITrigger.getId() == this.getId() && onceITrigger.getVersion() == this.getVersion() && ComparatorUtils.equals(onceITrigger.getStartTime(), this.getStartTime()) && onceITrigger.getStartType() == this.getStartType();
    }

    public Object clone() throws CloneNotSupportedException {
        OnceITrigger onceITrigger = (OnceITrigger)super.clone();
        if (this.getStartTime() != null) {
            onceITrigger.setStartTime((Date)this.getStartTime().clone());
        }
        return onceITrigger;
    }
}

