/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.trigger;

import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.DateUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.trigger.ITrigger;
import com.fr.third.org.quartz.SimpleTrigger;
import com.fr.third.org.quartz.Trigger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import oracle.sql.TIMESTAMP;

public class SimpleITrigger
implements ITrigger {
    public static final String TABLE_NAME = "fr_simple_itrigger";
    public static final int IMMEDIATE = 1;
    public static final int ON = 2;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    public static final int WEEKS = 4;
    private long id = -1L;
    private int version;
    private String timeZoneID = TimeZone.getDefault().getID();
    private long startType = 1L;
    private Date startTime = null;
    private long repeatCount = -1L;
    private Date endTime = null;
    private long recurrenceInterval = 1L;
    private long recurrenceIntervalUnit = 3L;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_simple_itrigger", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("timeZoneID", 12, "timezone_id"), new FieldMapper("startType", 4, "start_type"), new ValueFieldMapper("startTime", 93, "startTime"){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return object;
        }
    }, new FieldMapper("repeatCount", 4, "repeat_count"), new ValueFieldMapper("endTime", 93, "endTime"){

        public Object field2Value(Object object) {
            return object;
        }

        public Object value2Field(Object object) {
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
            if (object instanceof TIMESTAMP) {
                try {
                    return new Date(((TIMESTAMP)object).timestampValue().getTime());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            return object;
        }
    }, new FieldMapper("recurrenceInterval", 4, "recurrence_interval"), new FieldMapper("recurrenceIntervalUnit", 4, "recurrence_interval_unit")});

    public static SimpleITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            Date date;
            SimpleITrigger simpleITrigger = new SimpleITrigger();
            long l = jSONObject.getLong("startType");
            simpleITrigger.setStartType(l);
            if (l == 2L) {
                String string = jSONObject.getString("startTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    simpleITrigger.setStartTime(date);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            if (jSONObject.has("repeatCount")) {
                long l2 = jSONObject.getLong("repeatCount");
                simpleITrigger.setRepeatCount(l2);
            }
            if (jSONObject.has("endTime")) {
                String string = jSONObject.getString("endTime");
                try {
                    date = DateUtils.DATETIMEFORMAT2.parse(string);
                    simpleITrigger.setEndTime(date);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            long l3 = jSONObject.getLong("recurrenceInterval");
            simpleITrigger.setRecurrenceInterval(l3);
            long l4 = jSONObject.getLong("recurrenceIntervalUnit");
            simpleITrigger.setRecurrenceIntervalUnit(l4);
            if (jSONObject.has("id")) {
                simpleITrigger.setId(jSONObject.getLong("id"));
            }
            return simpleITrigger;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public JSONObject createJSONConfig() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            Date date;
            jSONObject.put("id", this.getId());
            jSONObject.put("startType", this.getStartType());
            if (2L == this.getStartType()) {
                date = this.getStartTime();
                string = DateUtils.DATETIMEFORMAT2.format(date);
                jSONObject.put("startTime", string);
            }
            jSONObject.put("recurrenceType", "simple");
            if (this.getEndTime() == null) {
                jSONObject.put("repeatCount", this.getRepeatCount());
            } else {
                date = this.getEndTime();
                string = DateUtils.DATETIMEFORMAT2.format(date);
                jSONObject.put("endTime", string);
            }
            jSONObject.put("recurrenceInterval", this.getRecurrenceInterval());
            jSONObject.put("recurrenceIntervalUnit", this.getRecurrenceIntervalUnit());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public Trigger createTrigger() {
        SimpleTrigger simpleTrigger = new SimpleTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                simpleTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("The statemenet is illegal.");
            }
        }
        if (this.getRepeatCount() > -2L) {
            simpleTrigger.setRepeatCount((int)this.getRepeatCount());
        }
        if (this.getEndTime() != null) {
            simpleTrigger.setEndTime(this.getEndTime());
        }
        long l = 0L;
        switch ((int)this.getRecurrenceIntervalUnit()) {
            case 1: {
                l = this.getRecurrenceInterval() * 60L * 1000L;
                break;
            }
            case 2: {
                l = this.getRecurrenceInterval() * 60L * 60L * 1000L;
                break;
            }
            case 3: {
                l = this.getRecurrenceInterval() * 24L * 60L * 60L * 1000L;
                break;
            }
            case 4: {
                l = this.getRecurrenceInterval() * 7L * 24L * 60L * 60L * 1000L;
            }
        }
        simpleTrigger.setRepeatInterval(l);
        return simpleTrigger;
    }

    public int getITriggerIdPrefix() {
        return 2;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public void setTimeZoneID(String string) {
        this.timeZoneID = string;
    }

    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    public void setStartType(long l) {
        this.startType = l;
    }

    public long getStartType() {
        return this.startType;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setRepeatCount(long l) {
        this.repeatCount = l;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setRecurrenceInterval(long l) {
        this.recurrenceInterval = l;
    }

    public long getRecurrenceInterval() {
        return this.recurrenceInterval;
    }

    public void setRecurrenceIntervalUnit(long l) {
        this.recurrenceIntervalUnit = l;
    }

    public long getRecurrenceIntervalUnit() {
        return this.recurrenceIntervalUnit;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleITrigger)) {
            return false;
        }
        SimpleITrigger simpleITrigger = (SimpleITrigger)object;
        return this.getId() == simpleITrigger.getId() && this.getVersion() == simpleITrigger.getVersion() && this.getStartType() == simpleITrigger.getStartType() && ComparatorUtils.equals(this.getStartTime(), simpleITrigger.getStartTime()) && this.getRepeatCount() == simpleITrigger.getRepeatCount() && ComparatorUtils.equals(this.getEndTime(), simpleITrigger.getEndTime()) && this.getRecurrenceInterval() == simpleITrigger.getRecurrenceInterval() && this.getRecurrenceIntervalUnit() == simpleITrigger.getRecurrenceIntervalUnit();
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleITrigger simpleITrigger = (SimpleITrigger)super.clone();
        return simpleITrigger;
    }
}

