/*
 * Decompiled with CFR 0.152.
 */
package com.fr.util;

import com.fr.base.BaseUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Base64 {
    private static char[] base64EncodeChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] base64DecodeChars = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    private Base64() {
    }

    public static String encode(Image image, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BaseUtils.writeImage(image, string, byteArrayOutputStream);
        return Base64.encode(byteArrayOutputStream.toByteArray());
    }

    public static BufferedImage decodeAsImage(String string) throws IOException {
        byte[] byArray = Base64.decode(string);
        return BaseUtils.readImage(new ByteArrayInputStream(byArray));
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2++] & 0xFF;
            if (n2 == n) {
                stringBuffer.append(base64EncodeChars[n3 >>> 2]);
                stringBuffer.append(base64EncodeChars[(n3 & 3) << 4]);
                stringBuffer.append("==");
                break;
            }
            int n4 = byArray[n2++] & 0xFF;
            if (n2 == n) {
                stringBuffer.append(base64EncodeChars[n3 >>> 2]);
                stringBuffer.append(base64EncodeChars[(n3 & 3) << 4 | (n4 & 0xF0) >>> 4]);
                stringBuffer.append(base64EncodeChars[(n4 & 0xF) << 2]);
                stringBuffer.append("=");
                break;
            }
            int n5 = byArray[n2++] & 0xFF;
            stringBuffer.append(base64EncodeChars[n3 >>> 2]);
            stringBuffer.append(base64EncodeChars[(n3 & 3) << 4 | (n4 & 0xF0) >>> 4]);
            stringBuffer.append(base64EncodeChars[(n4 & 0xF) << 2 | (n5 & 0xC0) >>> 6]);
            stringBuffer.append(base64EncodeChars[n5 & 0x3F]);
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        int n2 = 0;
        while (n2 < n) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            do {
                by4 = base64DecodeChars[byArray[n2++]];
            } while (n2 < n && by4 == -1);
            if (by4 == -1) break;
            do {
                by3 = base64DecodeChars[byArray[n2++]];
            } while (n2 < n && by3 == -1);
            if (by3 == -1) break;
            byteArrayOutputStream.write(by4 << 2 | (by3 & 0x30) >>> 4);
            do {
                if ((by2 = byArray[n2++]) == 61) {
                    return byteArrayOutputStream.toByteArray();
                }
                by2 = base64DecodeChars[by2];
            } while (n2 < n && by2 == -1);
            if (by2 == -1) break;
            byteArrayOutputStream.write((by3 & 0xF) << 4 | (by2 & 0x3C) >>> 2);
            do {
                if ((by = byArray[n2++]) == 61) {
                    return byteArrayOutputStream.toByteArray();
                }
                by = base64DecodeChars[by];
            } while (n2 < n && by == -1);
            if (by == -1) break;
            byteArrayOutputStream.write((by2 & 3) << 6 | by);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

