/*
 * Decompiled with CFR 0.152.
 */
package com.fr.util;

import com.fr.base.ArrayUtils;
import com.fr.base.BaseUtils;
import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.report.core.UploadedImage;
import com.fr.report.script.core.parser.OperationUtils;
import com.fr.util.OperatingSystem;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Utils {
    public static char[] FileNameInvalidChars = new char[]{'\"', '\'', '[', ']', '\\', '/', ':', '*', '?', '<', '>', '|'};
    private static Properties prop = null;
    private static String[] availableFontFamilyNames4Report = null;

    private Utils() {
    }

    public static void copy(InputStream inputStream, String string, File file) throws IOException {
        File file2 = new File(file, string);
        Utils.mkfile(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Utils.copyBinaryTo(inputStream, (OutputStream)fileOutputStream);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public static void copy(File file, File file2) throws IOException {
        File file3;
        if (file.isFile()) {
            Utils.copy(new FileInputStream(file), file.getName(), file2);
        } else if (file.isDirectory() && Utils.mkdirs(file3 = new File(file2, file.getName()))) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Utils.copy(fileArray[i], file3);
            }
        }
    }

    public static String doubleToString(double d) {
        return Utils.convertNumberStringToString(new Double(d));
    }

    public static String convertNumberStringToString(Number number) {
        if (OperationUtils.POSITIVE_INFINITY.equals(number)) {
            return "\u221e";
        }
        if (OperationUtils.NEGATIVE_INFINITY.equals(number)) {
            return "-\u221e";
        }
        String string = number.toString();
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(69);
        if (n == 1 && n2 > 0) {
            int n3;
            String string2 = string.substring(0, n2);
            StringBuffer stringBuffer = new StringBuffer(string2.substring(2));
            stringBuffer.insert(0, string2.charAt(0));
            String string3 = string.substring(n2 + 1);
            if (string3.startsWith("+")) {
                string3 = string3.substring(1);
            }
            if ((n3 = Integer.parseInt(string3)) <= 0) {
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                for (int i = 0; i < -n3; ++i) {
                    stringBuffer.insert(0, "0");
                }
                stringBuffer.insert(1, ".");
            } else if (stringBuffer.length() > n3 + 1) {
                stringBuffer.insert(n3 + 1, '.');
            } else {
                while (stringBuffer.length() < n3 + 1) {
                    stringBuffer.append("0");
                }
            }
            return stringBuffer.toString();
        }
        String string4 = string.substring(n + 1);
        int n4 = string4.indexOf("9999");
        if (n4 >= 0) {
            long l;
            double d = Double.parseDouble(string);
            if (n4 == 0) {
                return Long.toString(Math.round(d));
            }
            if (Math.abs(d) > 9.223372036854776E18) {
                String string5 = Double.toString(d);
                int n5 = string5.indexOf(".");
                if (n5 > 0 && string5.length() - n5 - 1 > n4) {
                    string5 = string5.substring(0, n5 + n4 + 1);
                }
                if (string5.endsWith(".0")) {
                    return string5.substring(0, string5.length() - 2);
                }
                return string5;
            }
            String string6 = d < 0.0 ? "-" : "";
            long l2 = (long)Math.pow(10.0, n4 - 1);
            long l3 = l2 * 10L;
            d = Math.abs(d);
            long l4 = Math.round(d * (double)l3);
            String string7 = string6 + Long.toString(l4 / l3);
            long l5 = l = l3 == 0L ? 0L : l4 % l3;
            if (l < 0L) {
                return string;
            }
            if (l == 0L) {
                StringBuffer stringBuffer = new StringBuffer("");
                for (int i = n4; i > 0; --i) {
                    stringBuffer.insert(0, "0");
                }
                return string7 + "." + stringBuffer;
            }
            StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
            while (l < l2) {
                l *= 10L;
                stringBuffer.insert(0, "0");
            }
            return string7 + "." + stringBuffer;
        }
        n4 = string4.indexOf("0000");
        if (n4 >= 0) {
            string = string.substring(0, n + Math.max(n4, 1) + 1);
        }
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static Object blob2Object(Blob blob, boolean bl) {
        if (bl) {
            try {
                return BaseUtils.readImage(blob.getBinaryStream());
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        } else {
            try {
                return Utils.inputStream2Object(blob.getBinaryStream());
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            }
        }
        return null;
    }

    public static String clob2String(Clob clob) {
        if (clob == null) {
            return "";
        }
        try {
            return Utils.reader2String(clob.getCharacterStream());
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
            return "";
        }
    }

    public static Object inputStream2Object(InputStream inputStream) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = BaseUtils.readImage(inputStream);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        if (bufferedImage != null) {
            return bufferedImage;
        }
        return Utils.inputStream2String(inputStream);
    }

    public static String reader2String(Reader reader) {
        if (reader == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            Utils.copyCharTo(reader, stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            reader.close();
            stringWriter.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            try {
                reader.close();
            }
            catch (IOException iOException2) {
                FRContext.getLogger().log(Level.WARNING, iOException2.getMessage(), iOException2);
            }
            try {
                stringWriter.close();
            }
            catch (IOException iOException3) {
                FRContext.getLogger().log(Level.WARNING, iOException3.getMessage(), iOException3);
            }
            return "";
        }
    }

    public static String inputStream2String(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] inputStream2Bytes(InputStream inputStream) {
        byte[] byArray;
        block9: {
            int n;
            byte[] byArray2 = new byte[32768];
            byArray = new byte[]{};
            while ((n = inputStream.read(byArray2)) > 0) {
                byte[] byArray3 = byArray2.length == n ? byArray2 : ArrayUtils.subarray(byArray2, 0, n);
                byArray = ArrayUtils.addAll(byArray, byArray3);
            }
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
            break block9;
            {
                catch (IOException iOException) {
                    FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
                    Object var6_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        FRContext.getLogger().log(Level.WARNING, iOException2.getMessage(), iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
                }
                throw throwable;
            }
        }
        return byArray;
    }

    public static Number objectToNumber(Object object, boolean bl) {
        if (object == null) {
            return bl ? null : new Integer(0);
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        String string = Utils.objectToString(object);
        Number number = Utils.string2Number(string);
        if (number == null && !bl) {
            number = new Integer(0);
        }
        return number;
    }

    public static Number string2Number(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("+")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("0") && string.length() > 1 && !string.startsWith("0E") && !string.startsWith("0.")) {
            return null;
        }
        if (string.matches("[\\-]?\\d+")) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return new BigInteger(string);
            }
        }
        if (string.matches("[\\-]?\\d+([\\.]\\d+)?([Ee][\\-\\+]?\\d+)?")) {
            try {
                Double d = Double.valueOf(string);
                if (d.toString().equals(string)) {
                    return d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new BigDecimal(string);
        }
        return null;
    }

    public static String objectToString(Object object) {
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return Utils.convertNumberStringToString((Number)object);
        }
        if (object instanceof Date) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            if (object instanceof Time) {
                return defaultValues.getTimeFormat().format(object);
            }
            String string = defaultValues.getDateTimeFormat().format(object);
            if (string.endsWith("00:00:00")) {
                return string.substring(0, string.length() - 9);
            }
            return string;
        }
        if (object instanceof Image || object instanceof UploadedImage) {
            return "";
        }
        return object.toString();
    }

    public static Color getXORColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static int filterRGB(int n, int n2) {
        int n3 = (int)((0.3 * (double)(n >> 16 & 0xFF) + 0.59 * (double)(n >> 8 & 0xFF) + 0.11 * (double)(n & 0xFF)) / 3.0);
        if ((n3 = 255 - (255 - n3) * (100 - n2) / 100) < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return n & 0xFF000000 | n3 << 16 | n3 << 8 | n3;
    }

    public static String[] splitString(String string, char c) {
        return Utils.splitString(string, "" + c);
    }

    public static String[] splitString(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        return string.split("\\Q" + string2 + "\\E");
    }

    public static int[] splitStringToIntArray(String string, String string2) {
        String[] stringArray = Utils.splitString(string, string2);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nArray;
    }

    public static void swap(List list, int n, int n2) {
        Object e = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, e);
    }

    public static String replaceAllString(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            string = Utils.replaceAllString(string, stringArray[i], stringArray2[i]);
        }
        return string;
    }

    public static String replaceAllString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\Q" + string2 + "\\E", Utils.filterString(string3));
    }

    private static String filterString(String string) {
        if (string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                stringBuffer.append("\\$");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void copyBinaryTo(File file, OutputStream outputStream) throws IOException {
        Utils.copyBinaryTo(new FileInputStream(file), outputStream);
    }

    public static void copyBinaryTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static void copyCharTo(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[32768];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.flush();
    }

    public static int[] grabImagePixelsArray(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            FRContext.getLogger().log(Level.WARNING, interruptedException.getMessage(), interruptedException);
        }
        return nArray;
    }

    public static boolean mkdirs(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean mkfile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        Utils.mkdirs(file.getParentFile());
        file.createNewFile();
        return true;
    }

    public static String javaColorToCSSColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer("rgb(");
        stringBuffer.append(color.getRed());
        stringBuffer.append(",");
        stringBuffer.append(color.getGreen());
        stringBuffer.append(",");
        stringBuffer.append(color.getBlue());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static boolean isFileNameInvalidChar(char c) {
        for (int i = 0; i < FileNameInvalidChars.length; ++i) {
            if (c != FileNameInvalidChars[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (Utils.deleteFile(fileArray[i]) || !bl) continue;
                bl = false;
            }
        }
        bl = file.delete() && bl;
        return bl;
    }

    public static String createWhiteSpaceString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return Utils.getDeclaredMethod(clazz, string, classArray);
            }
            return null;
        }
    }

    public static Field getDeclaredField(Class clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                return Utils.getDeclaredField(clazz, string);
            }
            return null;
        }
    }

    public static boolean classInstanceOf(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (!Utils.classInstanceOf(classArray[i], clazz2)) continue;
                return true;
            }
        }
        return Utils.classInstanceOf(clazz.getSuperclass(), clazz2);
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static byte[] objectToByte(Object object) {
        byte[] byArray = new byte[]{};
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("translation" + exception.getMessage());
            exception.printStackTrace();
        }
        return byArray;
    }

    public static String getInstallHome() {
        String string = System.getProperty("user.dir");
        if (string == null) {
            return "d:\\opt\\FineReport_6.5\\";
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(".exe") == -1) continue;
                return file.getParent();
            }
        }
        return "d:\\opt\\FineReport_6.5\\";
    }

    public static Properties getSystemEnvs() throws Exception {
        String string;
        if (prop != null) {
            return prop;
        }
        prop = new Properties();
        Process process = null;
        if (!OperatingSystem.isWindows()) {
            return prop;
        }
        process = Runtime.getRuntime().exec("cmd /c set");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf("=");
            if (n <= -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            prop.setProperty(string2, string3);
        }
        return prop;
    }

    public static void zip(ZipOutputStream zipOutputStream, File file, String string) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
            string = string.length() == 0 ? "" : string + "/";
            for (int i = 0; i < fileArray.length; ++i) {
                Utils.zip(zipOutputStream, fileArray[i], string + fileArray[i].getName());
            }
        } else {
            FRContext.getLogger().log(Level.INFO, "compress files" + string);
            zipOutputStream.putNextEntry(new ZipEntry(string));
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            zipOutputStream.flush();
        }
    }

    public static String[] getAvailableFontFamilyNames4Report() {
        if (availableFontFamilyNames4Report == null) {
            List<String> list = Arrays.asList("serif", "sansserif", "monospaced", "dialog", "dialoginput");
            ArrayList<String> arrayList = new ArrayList<String>();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment != null) {
                String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (list.indexOf(stringArray[i].toLowerCase()) >= 0) continue;
                    arrayList.add(stringArray[i]);
                }
            }
            availableFontFamilyNames4Report = arrayList.toArray(new String[arrayList.size()]);
        }
        return availableFontFamilyNames4Report;
    }

    public static void openWindowsFolder(String string) {
        if (!OperatingSystem.isWindows()) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            try {
                Runtime.getRuntime().exec("explorer /select, " + file.getAbsolutePath());
            }
            catch (IOException iOException) {}
        } else if (file.isDirectory()) {
            try {
                Runtime.getRuntime().exec("explorer " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

