/*
 * Decompiled with CFR 0.152.
 */
package com.fr.view;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.dav.Env;
import com.fr.base.print.PrintUtils;
import com.fr.cell.core.layout.LayoutFactory;
import com.fr.dialog.core.ParameterInputDialog;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.parameter.Parameter;
import com.fr.view.core.InnerPreviewPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PreviewPane
extends JPanel {
    private JButton firstButton;
    private JButton nextButton;
    private JTextField pageText;
    private JButton previousButton;
    private JButton lastButton;
    private JButton printButton;
    private InnerPreviewPane innerPreviewPane;
    private int currentPage;
    private TemplateWorkBook backupTemplate;
    private TemplateWorkBook currentTemplate;
    private PageSet reportPageSet = null;
    private int currentIndex = -1;
    private Map parameterMap = Collections.EMPTY_MAP;
    private ActionListener nextActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPane.this.showNextPage();
        }
    };
    private ActionListener previousActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPane.this.showPreviousPage();
        }
    };
    private ActionListener firstActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPane.this.showFirstPage();
        }
    };
    private ActionListener lastActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPane.this.showLastPage();
        }
    };
    private ActionListener printActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PrintUtils.print(PreviewPane.this.reportPageSet.getTraversingCase());
            }
            catch (PrinterException printerException) {
                FRContext.getLogger().log(Level.WARNING, printerException.getMessage(), printerException);
                JOptionPane.showMessageDialog(PreviewPane.this, printerException.getMessage());
            }
        }
    };
    private MouseListener firstMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreviewPane.this.firstButton.isEnabled()) {
                PreviewPane.this.firstButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PreviewPane.this.firstButton.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private MouseListener previousMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreviewPane.this.previousButton.isEnabled()) {
                PreviewPane.this.previousButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PreviewPane.this.previousButton.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private MouseListener nextMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreviewPane.this.nextButton.isEnabled()) {
                PreviewPane.this.nextButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PreviewPane.this.nextButton.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private MouseListener lastMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreviewPane.this.lastButton.isEnabled()) {
                PreviewPane.this.lastButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PreviewPane.this.lastButton.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private MouseListener printMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreviewPane.this.printButton.isEnabled()) {
                PreviewPane.this.printButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PreviewPane.this.printButton.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };

    public PreviewPane() {
        this.setLayout(LayoutFactory.createBorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.add((Component)jToolBar, "North");
        jToolBar.setLayout(new FlowLayout(0, 4, 2));
        this.firstButton = new JButton();
        this.firstButton.setIcon(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/first.png"));
        this.firstButton.setToolTipText(Inter.getLocText("First"));
        this.firstButton.setMnemonic('F');
        this.firstButton.setBorderPainted(false);
        this.firstButton.setOpaque(false);
        this.firstButton.addMouseListener(this.firstMouseListener);
        this.firstButton.addActionListener(this.firstActionListener);
        jToolBar.add(this.firstButton);
        this.previousButton = new JButton();
        this.previousButton.setIcon(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/left.png"));
        this.previousButton.setToolTipText(Inter.getLocText("ReportServerP-Previous"));
        this.previousButton.setMnemonic('P');
        this.previousButton.setBorderPainted(false);
        this.previousButton.setOpaque(false);
        this.previousButton.addMouseListener(this.previousMouseListener);
        this.previousButton.addActionListener(this.previousActionListener);
        jToolBar.add(this.previousButton);
        this.pageText = new JTextField(3);
        this.pageText.setHorizontalAlignment(0);
        this.pageText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPane.this.showPage(Integer.parseInt(PreviewPane.this.pageText.getText().toString()) - 1);
                PreviewPane.this.pageText.setText(PreviewPane.this.currentIndex + 1 + "");
            }
        });
        jToolBar.add(this.pageText);
        this.nextButton = new JButton();
        this.nextButton.setIcon(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/right.png"));
        this.nextButton.setToolTipText(Inter.getLocText("ReportServerP-Next"));
        this.nextButton.setMnemonic('N');
        this.nextButton.setBorderPainted(false);
        this.nextButton.setOpaque(false);
        this.nextButton.addMouseListener(this.nextMouseListener);
        this.nextButton.addActionListener(this.nextActionListener);
        jToolBar.add(this.nextButton);
        this.lastButton = new JButton();
        this.lastButton.setSize(1, 1);
        this.lastButton.setIcon(BaseUtils.readIcon("/com/fr/cell/images/tabscroll/last.png"));
        this.lastButton.setToolTipText(Inter.getLocText("ReportServerP-Last"));
        this.lastButton.setMnemonic('L');
        this.lastButton.setBorderPainted(false);
        this.lastButton.setOpaque(false);
        this.lastButton.addMouseListener(this.lastMouseListener);
        this.lastButton.addActionListener(this.lastActionListener);
        jToolBar.add(this.lastButton);
        JSeparator jSeparator = new JSeparator();
        jToolBar.add(jSeparator);
        this.printButton = new JButton();
        this.printButton.setIcon(BaseUtils.readIcon("/com/fr/design/images/m_file/print.png"));
        this.printButton.setToolTipText(Inter.getLocText("Print"));
        jToolBar.add(this.printButton);
        this.printButton.setMnemonic('T');
        this.printButton.setBorderPainted(false);
        this.printButton.setOpaque(false);
        this.printButton.addMouseListener(this.printMouseListener);
        this.printButton.addActionListener(this.printActionListener);
        this.innerPreviewPane = new InnerPreviewPane();
        this.add((Component)new JScrollPane(this.innerPreviewPane), "Center");
    }

    private void checkButtonEnabled() {
        this.firstButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.lastButton.setEnabled(false);
        this.printButton.setEnabled(false);
        if (this.currentIndex > 0) {
            this.previousButton.setEnabled(true);
            this.firstButton.setEnabled(true);
        }
        if (!this.reportPageSet.sizePredictable() || this.currentIndex < this.reportPageSet.size() - 1) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }
        if (this.reportPageSet.size() > 0) {
            this.printButton.setEnabled(true);
        }
    }

    private void showPage(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n == this.currentIndex) {
            return;
        }
        ReportPage reportPage = this.reportPageSet.getPage(n);
        if (reportPage == null && this.reportPageSet.sizePredictable()) {
            n = this.reportPageSet.size() - 1;
            reportPage = this.reportPageSet.getPage(n);
        }
        this.innerPreviewPane.print(reportPage);
        this.currentIndex = n;
        this.checkButtonEnabled();
    }

    private void showFirstPage() {
        this.showPage(0);
        this.currentPage = 0;
        this.pageText.setText(this.currentPage + 1 + "");
    }

    private void showPreviousPage() {
        this.showPage(Math.max(0, this.currentIndex - 1));
        this.currentPage = Math.max(0, this.currentIndex - 1);
        this.pageText.setText(this.currentIndex + 1 + "");
    }

    private void showNextPage() {
        this.showPage(this.currentIndex + 1);
        this.currentPage = this.currentIndex;
        this.pageText.setText(this.currentPage + 1 + "");
    }

    private void showLastPage() {
        this.showPage(Integer.MAX_VALUE);
        this.currentPage = this.reportPageSet.sizePredictable() ? this.currentIndex + 1 : this.reportPageSet.size();
        this.pageText.setText(this.currentPage + "");
    }

    public void print(TemplateWorkBook templateWorkBook) {
        this.backupTemplate = templateWorkBook;
        Env env = FRContext.getCurrentEnv();
        try {
            this.currentTemplate = (TemplateWorkBook)templateWorkBook.clone();
            Parameter[] parameterArray = env.getTemplateParameters(this.currentTemplate);
            Parameter[] parameterArray2 = new Parameter[parameterArray.length];
            for (int i = 0; i < parameterArray.length; ++i) {
                parameterArray2[i] = (Parameter)parameterArray[i].clone();
            }
            if (parameterArray2 != null && parameterArray2.length > 0) {
                ParameterInputDialog parameterInputDialog = ParameterInputDialog.showWindow(SwingUtilities.getWindowAncestor(this), parameterArray2);
                if (parameterInputDialog.getReturnValue() != 0) {
                    throw new RuntimeException("cancel");
                }
                this.parameterMap = parameterInputDialog.update();
            }
            ReportHelper.clearFormulaResult(this.currentTemplate);
            ResultWorkBook resultWorkBook = env.executeTemplate(this.currentTemplate, this.parameterMap);
            this.print(resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)));
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void print(PageSet pageSet) {
        this.reportPageSet = pageSet;
        this.currentIndex = -1;
        this.innerPreviewPane.print((ReportPage)null);
        this.checkButtonEnabled();
        this.showNextPage();
    }

    public void releasePageSet() {
        if (this.reportPageSet != null) {
            this.reportPageSet.release();
        }
    }
}

