/*
 * Decompiled with CFR 0.152.
 */
package com.fr.view.core;

import com.fr.base.background.ColorBackground;
import com.fr.base.core.GraphHelper;
import com.fr.report.PaperSize;
import com.fr.report.Report;
import com.fr.report.ReportPage;
import com.fr.report.ReportSettings;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.painter.PagePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class InnerPreviewPane
extends JPanel
implements Scrollable {
    private ReportPage reportPage;
    private boolean adjustMargin = false;
    private int dragType = DEFAULT;
    private int dragXY = -1;
    private int columnIndex = -1;
    public static int DEFAULT = 0;
    public static int MARGIN_TOP = 1;
    public static int MARGIN_LEFT = 2;
    public static int MARGIN_BOTTOM = 3;
    public static int MARGIN_RIGHT = 4;
    public static int COLUMN = 5;

    public InnerPreviewPane() {
        this.setBackground(new Color(128, 128, 128));
        this.setOpaque(false);
    }

    public boolean isAdjustMargin() {
        return this.adjustMargin;
    }

    public void setAdjustMargin(boolean bl) {
        this.adjustMargin = bl;
    }

    public int getDragType() {
        return this.dragType;
    }

    public void setDragType(int n) {
        this.dragType = n;
    }

    public int getDragXY() {
        return this.dragXY;
    }

    public void setDragXY(int n) {
        this.dragXY = n;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int n) {
        this.columnIndex = n;
    }

    public void print(ReportPage reportPage) {
        this.reportPage = reportPage;
        this.getParent().validate();
        this.getParent().doLayout();
        this.repaint(10L);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        if (this.reportPage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        ReportSettings reportSettings = this.reportPage.getReportSettings();
        int n2 = this.reportPage.getPageWidth();
        int n3 = this.reportPage.getPageHeight();
        int n4 = this.reportPage.getMarginTop();
        int n5 = this.reportPage.getMarginLeft();
        int n6 = this.reportPage.getMarginBottom();
        int n7 = this.reportPage.getMarginRight();
        graphics2D.translate((dimension.getWidth() - (double)n2) / 2.0, 8.0);
        Report report = this.reportPage.getSourceReport();
        int n8 = 0;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (reportSettings.isLonelyPage()) {
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
            DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(report);
            int n10 = report.getColumnCount();
            int n11 = report.getRowCount();
            for (n = 0; n < n10; ++n) {
                n8 += dynamicValueList.get(n);
            }
            for (n = 0; n < n11; ++n) {
                n9 += dynamicValueList2.get(n);
            }
            d = (double)n2 / ((double)(n5 + n7) + (double)n8);
            d2 = (double)n3 / ((double)n9 + (double)n4 + (double)n6);
            d = d < 1.0 ? d : 1.0;
            d2 = d2 < 1.0 ? d2 : 1.0;
            graphics2D.scale(d, d2);
            ColorBackground.getInstance(Color.white).paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, d == 1.0 ? (double)n2 : (double)(n5 + n7) + (double)n8, d2 == 1.0 ? (double)n3 : (double)n9 + (double)n4 + (double)n6));
        }
        new PagePainter(this.reportPage, graphics2D, false).convert();
        graphics2D.setPaint(UIManager.getColor("controlDkShadow"));
        if (reportSettings.isLonelyPage()) {
            GraphHelper.drawRect(graphics2D, 0.0, 0.0, d == 1.0 ? (double)n2 : (double)(n5 + n7) + (double)n8, d2 == 1.0 ? (double)n3 : (double)n9 + (double)n4 + (double)n6);
        } else {
            GraphHelper.drawRect(graphics2D, 0.0, 0.0, n2, n3);
        }
        if (this.isAdjustMargin()) {
            graphics2D.setPaint(Color.DARK_GRAY);
            GraphHelper.drawLine(graphics2D, 0.0, n4, n2, n4, 7);
            GraphHelper.drawLine(graphics2D, 0.0, n3 - n6, n2, n3 - n6, 7);
            GraphHelper.drawLine(graphics2D, n5, 0.0, n5, n3, 7);
            GraphHelper.drawLine(graphics2D, n2 - n7, 0.0, n2 - n7, n3, 7);
            graphics2D.setPaint(Color.BLACK);
            double d3 = 1.5;
            double d4 = 8.0;
            GraphHelper.fillRect(graphics2D, 0.0, (double)n4 - d3, d4, d3 * 2.0 + 1.0);
            GraphHelper.fillRect(graphics2D, (double)n2 - d4, (double)n4 - d3, d4, d3 * 2.0 + 1.0);
            GraphHelper.fillRect(graphics2D, (double)n5 - d3, 0.0, d3 * 2.0 + 1.0, d4);
            GraphHelper.fillRect(graphics2D, (double)n5 - d3, (double)n3 - d4, d3 * 2.0 + 1.0, d4);
            GraphHelper.fillRect(graphics2D, 0.0, (double)(n3 - n6) - d3, d4, d3 * 2.0 + 1.0);
            GraphHelper.fillRect(graphics2D, (double)n2 - d4, (double)(n3 - n6) - d3, d4, d3 * 2.0 + 1.0);
            GraphHelper.fillRect(graphics2D, (double)(n2 - n7) - d3, 0.0, d3 * 2.0 + 1.0, d4);
            GraphHelper.fillRect(graphics2D, (double)(n2 - n7) - d3, (double)n3 - d4, d3 * 2.0 + 1.0, d4);
            n = n5;
            for (int i = 0; i < this.reportPage.getColumnCount(); ++i) {
                GraphHelper.fillRect(graphics2D, (double)(n += this.reportPage.getColumnWidth(i)) - d3, 0.0, d3 * 2.0 + 1.0, d4);
                GraphHelper.drawLine(graphics2D, n, 0.0, n, d4 * 3.0 / 2.0);
            }
            if (this.getDragType() != DEFAULT) {
                graphics2D.setPaint(Color.DARK_GRAY);
                if (this.dragType == MARGIN_LEFT || this.dragType == MARGIN_RIGHT || this.dragType == COLUMN) {
                    GraphHelper.drawLine(graphics2D, this.getDragXY(), 0.0, this.getDragXY(), n3, 7);
                } else if (this.dragType == MARGIN_TOP || this.dragType == MARGIN_BOTTOM) {
                    GraphHelper.drawLine(graphics2D, 0.0, this.getDragXY(), n2, this.getDragXY(), 7);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.reportPage == null) {
            return new Dimension((int)PaperSize.PAPERSIZE_A4.getWidth() * 96, (int)PaperSize.PAPERSIZE_A4.getHeight() * 96);
        }
        return new Dimension(this.reportPage.getPageWidth(), this.reportPage.getPageHeight() + 16);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }
}

