/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.core.html.Tag;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class Browser {
    private String userAgent;
    private String browser;
    private String version;
    private static Pattern[] uaPatterns = new Pattern[]{Pattern.compile("(webkit)[ \\/]([\\w.]+)"), Pattern.compile("(opera)(?:.*version)?[ \\/]([\\w.]+)"), Pattern.compile("(msie) ([\\w.]+)"), Pattern.compile("(mozilla)(?:.*? rv:([\\w.]+))?")};

    public static Browser resolve(HttpServletRequest httpServletRequest) {
        return Browser.resolve(httpServletRequest.getHeader("user-agent"));
    }

    public static Browser resolve(String string) {
        string = string.toLowerCase();
        Browser browser = new Browser();
        browser.userAgent = string;
        for (int i = 0; i < uaPatterns.length; ++i) {
            Matcher matcher = uaPatterns[i].matcher(string);
            if (!matcher.find()) continue;
            browser.browser = matcher.group(1);
            browser.version = matcher.group(2);
            break;
        }
        return browser;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getVersion() {
        return this.version;
    }

    private boolean isIE() {
        return "msie".equals(this.browser);
    }

    private boolean isOpera() {
        return "opera".equals(this.browser);
    }

    private boolean isWebkit() {
        return "webkit".equals(this.browser);
    }

    private boolean isFireFox() {
        return "mozilla".equals(this.browser);
    }

    private boolean versionLessThan(String string) {
        String[] stringArray = this.version.split("\\.");
        String[] stringArray2 = string.split("\\.");
        int n = Math.max(stringArray2.length, stringArray.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = stringArray.length > i ? Integer.parseInt(stringArray[i]) : 0;
            int n4 = n2 = stringArray2.length > i ? Integer.parseInt(stringArray2[i]) : 0;
            if (n3 >= n2) continue;
            return true;
        }
        return false;
    }

    private boolean versionLargerThan(String string) {
        String[] stringArray = this.version.split("\\.");
        String[] stringArray2 = string.split("\\.");
        int n = Math.max(stringArray2.length, stringArray.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = stringArray.length > i ? Integer.parseInt(stringArray[i]) : 0;
            int n4 = n2 = stringArray2.length > i ? Integer.parseInt(stringArray2[i]) : 0;
            if (n3 <= n2) continue;
            return true;
        }
        return false;
    }

    public String getEncodedFileName4Download(String string) throws UnsupportedEncodingException {
        if (this.isIE()) {
            return URLEncoder.encode(string, "UTF-8");
        }
        return new String(string.getBytes("UTF-8"), "ISO8859-1");
    }

    public boolean supportTransparentImage() {
        return !this.isIE() || !this.versionLessThan("7.0");
    }

    public boolean shouldSetContentTypeOnZipDownload() {
        return !this.isIE();
    }

    public boolean supportGzip() {
        return !this.isIE();
    }

    public void setHrefOnArea(Tag tag) {
        if (!this.isFireFox()) {
            if (this.isIE() && !this.versionLessThan("6.0")) {
                tag.attr("href", "###");
            } else {
                tag.attr("href", "javascript:void(0)");
            }
        }
    }

    public boolean shouldSetOverflowAsHiddenOnSheetContainer() {
        return !this.isFireFox();
    }

    public boolean shouldWrapCenter() {
        return this.isIE();
    }

    public boolean shouldModifyWidth4PainterAccordingToBorderWidth() {
        return this.isIE();
    }

    public boolean shouldDoSomeStuff4MissingRightBorderOfTable() {
        return this.isWebkit();
    }

    public boolean justDealWithTheHiddenRowsOfTail() {
        return this.isIE();
    }

    public boolean shouldConsiderHeavyTD() {
        return !this.isIE() || this.versionLessThan("6.0");
    }

    public boolean supportIMAGEBase64Decode() {
        return !this.isIE();
    }
}

