/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONObject;
import com.fr.privilege.filter.core.FRSecurityDispatcher;
import com.fr.util.Consts;
import com.fr.web.Browser;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.ReportDispatcher;
import com.fr.web.core.ServerEnv;
import com.fr.web.core.gzip.GZIPResponseWrapper;
import com.fr.web.platform.exception.RedirectException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 2204797189775876731L;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        FRContext.setLanguage(FRContext.getConfigManager().getServerLanguage());
        ServletContext servletContext = this.getServletContext();
        try {
            if (FRContext.getCurrentEnv() == null) {
                FRContext.setCurrentEnv(new ServerEnv(servletContext));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage());
        }
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
        boolean bl = false;
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            String string = servletConfig.getServletContext().getRealPath("").substring(servletConfig.getServletContext().getRealPath("").lastIndexOf("\\") + 1);
            if (jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < new Long("3153600000") || !jSONObject.has("macaddress") || !BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress")) || !jSONObject.has("appname") || ComparatorUtils.equals(string, jSONObject.getString("appname")))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        servletContext.setAttribute("__initTime_", (Object)new Long(bl ? 0L : System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse object) throws IOException, ServletException {
        GZIPResponseWrapper gZIPResponseWrapper = null;
        try {
            String string = httpServletRequest.getHeader("accept-encoding");
            if (FRContext.getConfigManager().isSupportGzip() && !"false".equals(httpServletRequest.getParameter("gzip")) && string != null && string.indexOf("gzip") != -1 && Browser.resolve(httpServletRequest).supportGzip()) {
                gZIPResponseWrapper = new GZIPResponseWrapper((HttpServletResponse)object);
            }
            if (gZIPResponseWrapper != null) {
                object = gZIPResponseWrapper;
            }
            object.addHeader("P3P", "CP=CAO PSA OUR");
            FRSecurityDispatcher.dealWithRequest(httpServletRequest, object);
            ReportDispatcher.dealWithRequest(httpServletRequest, object);
        }
        catch (RedirectException redirectException) {
            FRContext.getLogger().log(Level.INFO, redirectException.getMessage());
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.SEVERE, exception.getMessage(), exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, (HttpServletResponse)object, exception);
        }
        finally {
            if (gZIPResponseWrapper != null) {
                gZIPResponseWrapper.finishResponse();
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
    }
}

