/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.CodeUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONObject;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.util.Base64;
import com.fr.web.Browser;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import java.awt.Image;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Repository {
    private HttpServletRequest req;
    private SessionIDInfor sessionIDInfor;
    private String servletURL;
    private Browser browser;
    private Authentication authentication;

    public Repository(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        this.req = httpServletRequest;
        this.sessionIDInfor = sessionIDInfor;
        this.servletURL = WebUtils.createServletURL(httpServletRequest);
        this.browser = Browser.resolve(httpServletRequest);
        this.authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Authentication getCurrentAuthentication() {
        return this.authentication;
    }

    public String checkoutReportletPath(String string) {
        return this.servletURL + "?reportlet=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string));
    }

    public String checkoutResourcePath(String string) {
        return this.servletURL + "?op=resource&resource=" + CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string));
    }

    public String checkoutImage(Image image) {
        if (this.browser.supportIMAGEBase64Decode()) {
            return "data:image/png;base64," + Base64.encode(image, "png");
        }
        return this.servletURL + "?op=attach_image&id=" + this.sessionIDInfor.addReportPageImage(image);
    }

    public String checkoutWidgetUrl(JSONObject jSONObject, String string) {
        return this.servletURL + "?op=widget" + (string == null ? "" : "&ftype=" + string) + "&location=" + jSONObject.toString() + "&sessionID=" + this.getSessionIDInfor().getSessionID();
    }

    public Tag checkoutImageTag(Image image, int n, int n2) {
        Tag tag = new Tag("img").css("width", n + "px").css("height", n2 + "px").css("border", "0").attr("src", image == null ? this.blank_image() : this.checkoutImage(image));
        return tag;
    }

    public Map checkoutTplContext() {
        Map map = WebUtils.createTemplateMap(this.req);
        map.put("sessionID", this.sessionIDInfor == null ? "" : this.sessionIDInfor.getSessionID());
        return map;
    }

    public Object checkoutParameterValue(String string) {
        return this.sessionIDInfor.getParameterValue(string);
    }

    public void writeTagBackground(Tag tag, Image image, boolean bl) {
        String string = this.checkoutImage(image);
        if (this.browser.supportTransparentImage() || !bl) {
            tag.css("background", "url(" + string + ") no-repeat");
        } else {
            tag.css("filter", "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + string + "')");
        }
    }

    public void writeTagBackground(Tag tag, Image image) {
        this.writeTagBackground(tag, image, true);
    }

    public boolean isShowParameterPanel() {
        return !ComparatorUtils.equals(WebUtils.getHTTPRequestParameter(this.req, "__pi__"), "false");
    }

    private String blank_image() {
        return this.servletURL + "?op=resource&resource=/com/fr/web/images/s.gif";
    }

    public String getServletURL() {
        return this.servletURL;
    }

    public SessionIDInfor getSessionIDInfor() {
        return this.sessionIDInfor;
    }

    public boolean isNeedToolbar() {
        return !"false".equalsIgnoreCase(WebUtils.getHTTPRequestParameter(this.req, "__showtoolbar__"));
    }
}

