/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.web.cache.ReportCacheIdGenerator;
import com.fr.web.cache.ReportEntry;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;

public class ReportCache {
    private String id;
    private ReportEntry reportEntry;
    private Map paraMap;
    private SoftReference reference;
    private long createTime = -1L;
    private long lastAccessTime;
    private SoftReference pageSetRefernence;

    public ReportCache(ReportEntry reportEntry, Map map) {
        this.reportEntry = reportEntry;
        this.paraMap = map;
        this.lastAccessTime = System.currentTimeMillis();
        this.id = ReportCacheIdGenerator.getId();
    }

    public long createTime() {
        return this.createTime;
    }

    public boolean accept(Map map) {
        if (this.paraMap == null || map == null) {
            return map == this.paraMap;
        }
        if (this.paraMap.size() != map.size()) {
            return false;
        }
        Iterator iterator = this.paraMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (entry.getValue().equals(map.get(k))) continue;
            return false;
        }
        return true;
    }

    public synchronized ResultWorkBook getResultWorkBook(TemplateWorkBook templateWorkBook) {
        ResultWorkBook resultWorkBook;
        if (this.reference == null || (resultWorkBook = (ResultWorkBook)this.reference.get()) == null) {
            resultWorkBook = templateWorkBook.execute(this.paraMap);
            this.reference = new SoftReference<ResultWorkBook>(resultWorkBook);
            this.createTime = this.lastAccessTime = System.currentTimeMillis();
            return resultWorkBook;
        }
        if (resultWorkBook == null) {
            // empty if block
        }
        return resultWorkBook;
    }

    private synchronized ResultWorkBook getResultWorkBook() {
        ResultWorkBook resultWorkBook;
        if (this.reference == null || (resultWorkBook = (ResultWorkBook)this.reference.get()) == null) {
            TemplateWorkBook templateWorkBook = this.reportEntry.getWorkBookTemplate();
            resultWorkBook = templateWorkBook.execute(this.paraMap);
            this.reference = new SoftReference<ResultWorkBook>(resultWorkBook);
            this.createTime = this.lastAccessTime = System.currentTimeMillis();
            return resultWorkBook;
        }
        if (resultWorkBook == null) {
            // empty if block
        }
        return resultWorkBook;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }
}

