/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.report.TemplateWorkBook;
import com.fr.util.Consts;
import com.fr.web.cache.ReportCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class ReportEntry {
    private static boolean shareAvailable = true;
    private String bookPath;
    private Map reportCacheMap = new HashMap(16);
    private SoftReference reference;
    private long lastAccessTime = -1L;

    public ReportEntry(String string) {
        this.bookPath = string;
    }

    public synchronized TemplateWorkBook getWorkBookTemplate() {
        TemplateWorkBook templateWorkBook = null;
        if (!shareAvailable || FRContext.getCacheManager().isAlwaysReloadTpl() || this.reference == null || (templateWorkBook = (TemplateWorkBook)this.reference.get()) == null) {
            try {
                templateWorkBook = FRContext.getCurrentEnv().readTemplate(this.bookPath);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                throw new RuntimeException(exception.getMessage());
            }
            if (templateWorkBook != null) {
                this.reference = new SoftReference<TemplateWorkBook>(templateWorkBook);
            }
        }
        return templateWorkBook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportCache getReportCache(Map map, long l) {
        ReportCache reportCache = null;
        Map map2 = this.reportCacheMap;
        synchronized (map2) {
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            Iterator iterator = this.reportCacheMap.values().iterator();
            while (shareAvailable && iterator.hasNext()) {
                ReportCache reportCache2 = (ReportCache)iterator.next();
                long l4 = reportCache2.createTime();
                if (l4 < 0L) {
                    if (!reportCache2.accept(map)) continue;
                    reportCache = reportCache2;
                    break;
                }
                if (!reportCache2.accept(map)) continue;
                if (l != 0L && (l < 0L || l2 - l4 < l) && l4 > l3) {
                    reportCache = reportCache2;
                    l3 = l4;
                    continue;
                }
                iterator.remove();
            }
            if (reportCache == null) {
                reportCache = new ReportCache(this, map);
                if (shareAvailable) {
                    this.reportCacheMap.put(reportCache.getId(), reportCache);
                }
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
        return reportCache;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setBookPath(String string) {
        this.bookPath = string;
    }

    public String getBookPath() {
        return this.bookPath;
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            shareAvailable = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.PERFORMCE_OPTIMISE.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

