/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FRCoreContext;
import com.fr.web.EmbeddedResultResultlet;
import com.fr.web.ResultResultlet;
import com.fr.web.Resultlet;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ResultletFactory {
    public static Resultlet createResultletByRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resultlet");
        if (string != null) {
            if (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.toLowerCase().endsWith(".xml")) {
                return new ResultResultlet(string);
            }
            try {
                Object t = FRCoreContext.classForName(string).newInstance();
                if (t instanceof Resultlet) {
                    return (Resultlet)t;
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.INFO, exception.getMessage(), exception);
            }
            throw new RuntimeException(Inter.getLocText("EX-Can_not_create_WorkBook_from_Reportlet"));
        }
        return null;
    }

    public static Resultlet createEmbeddedResultlet(String string, ShowWorkBookPolicy showWorkBookPolicy) {
        return new EmbeddedResultResultlet(string, showWorkBookPolicy);
    }
}

