/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.FRCoreContext;
import com.fr.web.ADHOCReportlet;
import com.fr.web.EmbeddedResultResultlet;
import com.fr.web.EmbeddedTplReportlet;
import com.fr.web.MultiTemplateReportlet;
import com.fr.web.Reportlet;
import com.fr.web.ResultResultlet;
import com.fr.web.Resultlet;
import com.fr.web.ScheduleReportlet;
import com.fr.web.TemplateReportlet;
import com.fr.web.Weblet;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class WebletFactory {
    public static Weblet createWebletByRequest(HttpServletRequest httpServletRequest) {
        Weblet weblet = WebletFactory.createReportletByRequest(httpServletRequest);
        if (weblet == null) {
            weblet = WebletFactory.createResultletByRequest(httpServletRequest);
        }
        return weblet;
    }

    public static Reportlet createReportletByRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlets");
        if (string != null) {
            if (string.equalsIgnoreCase("adhocreport")) {
                return new ADHOCReportlet();
            }
            if (string.equalsIgnoreCase("schedulereport")) {
                return new ScheduleReportlet();
            }
            if (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.toLowerCase().endsWith(".cpt") || string.toLowerCase().endsWith(".fwb")) {
                return new TemplateReportlet(string);
            }
            try {
                Object t = FRCoreContext.classForName(string).newInstance();
                if (t instanceof Reportlet) {
                    return (Reportlet)t;
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.INFO, exception.getMessage(), exception);
            }
            throw new RuntimeException(Inter.getLocText("EX-Can_not_create_WorkBook_from_Reportlet"));
        }
        if (string2 != null) {
            MultiTemplateReportlet multiTemplateReportlet = new MultiTemplateReportlet(string2, null, WebUtils.parameters4SessionIDInfor(httpServletRequest));
            multiTemplateReportlet.setPolicy(ShowWorkBookPolicy.getInstance(httpServletRequest, multiTemplateReportlet));
            return multiTemplateReportlet;
        }
        return null;
    }

    public static Reportlet createEmbeddedReportlet(String string, ShowWorkBookPolicy showWorkBookPolicy, Map map) {
        return new EmbeddedTplReportlet(string, showWorkBookPolicy, map);
    }

    public static Reportlet createEmbeddedReportlet(String string, ShowWorkBookPolicy showWorkBookPolicy) {
        return new EmbeddedTplReportlet(string, showWorkBookPolicy);
    }

    public static Resultlet createResultletByRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resultlet");
        if (string != null) {
            if (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.toLowerCase().endsWith(".xml")) {
                return new ResultResultlet(string);
            }
            try {
                Object t = FRCoreContext.classForName(string).newInstance();
                if (t instanceof Resultlet) {
                    return (Resultlet)t;
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.INFO, exception.getMessage(), exception);
            }
            throw new RuntimeException(Inter.getLocText("EX-Can_not_create_WorkBook_from_Reportlet"));
        }
        return null;
    }

    public static Resultlet createEmbeddedResultlet(String string, ShowWorkBookPolicy showWorkBookPolicy) {
        return new EmbeddedResultResultlet(string, showWorkBookPolicy);
    }
}

